/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.util.world.capability;

import com.google.common.base.Objects;
import java.lang.ref.WeakReference;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import stevekung.mods.moreplanets.util.tileentity.TileEntityAncientChestMP;

public class DoubleAncientChestItemHandlerMP
extends WeakReference<TileEntityAncientChestMP>
implements IItemHandler {
    public static DoubleAncientChestItemHandlerMP NO_ADJACENT_CHESTS_INSTANCE = new DoubleAncientChestItemHandlerMP(null, null, false);
    private boolean mainChestIsUpper;
    private TileEntityAncientChestMP mainChest;
    private int hashCode;

    public DoubleAncientChestItemHandlerMP(TileEntityAncientChestMP mainChest, TileEntityAncientChestMP other, boolean mainChestIsUpper) {
        super(other);
        this.mainChest = mainChest;
        this.mainChestIsUpper = mainChestIsUpper;
        this.hashCode = Objects.hashCode((Object[])new Object[]{mainChestIsUpper ? mainChest : other}) * 31 + Objects.hashCode((Object[])new Object[]{!mainChestIsUpper ? mainChest : other});
    }

    public static DoubleAncientChestItemHandlerMP get(TileEntityAncientChestMP chest) {
        World world = chest.func_145831_w();
        BlockPos pos = chest.func_174877_v();
        if (world == null || pos == null || !world.func_175667_e(pos)) {
            return null;
        }
        Block blockType = chest.func_145838_q();
        EnumFacing[] horizontals = EnumFacing.field_176754_o;
        for (int i = horizontals.length - 1; i >= 0; --i) {
            TileEntity otherTE;
            EnumFacing enumfacing = horizontals[i];
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            Block block = world.func_180495_p(blockpos).func_177230_c();
            if (block != blockType || !((otherTE = world.func_175625_s(blockpos)) instanceof TileEntityAncientChestMP)) continue;
            TileEntityAncientChestMP otherChest = (TileEntityAncientChestMP)otherTE;
            return new DoubleAncientChestItemHandlerMP(chest, otherChest, enumfacing != EnumFacing.WEST && enumfacing != EnumFacing.NORTH);
        }
        return NO_ADJACENT_CHESTS_INSTANCE;
    }

    public TileEntityAncientChestMP getChest(boolean accessingUpper) {
        if (accessingUpper == this.mainChestIsUpper) {
            return this.mainChest;
        }
        return this.getOtherChest();
    }

    private TileEntityAncientChestMP getOtherChest() {
        TileEntityAncientChestMP tileEntityChest = (TileEntityAncientChestMP)((Object)this.get());
        return tileEntityChest != null && !tileEntityChest.func_145837_r() ? tileEntityChest : null;
    }

    public int getSlots() {
        return 54;
    }

    public ItemStack getStackInSlot(int slot) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        TileEntityAncientChestMP chest = this.getChest(accessingUpperChest);
        return chest != null ? chest.func_70301_a(targetSlot) : ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        TileEntityAncientChestMP chest = this.getChest(accessingUpperChest);
        return chest != null ? chest.getSingleChestHandler().insertItem(targetSlot, stack, simulate) : stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        TileEntityAncientChestMP chest = this.getChest(accessingUpperChest);
        return chest != null ? chest.getSingleChestHandler().extractItem(targetSlot, amount, simulate) : ItemStack.field_190927_a;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleAncientChestItemHandlerMP that = (DoubleAncientChestItemHandlerMP)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        TileEntityAncientChestMP otherChest = this.getOtherChest();
        if (this.mainChestIsUpper == that.mainChestIsUpper) {
            return Objects.equal((Object)((Object)this.mainChest), (Object)((Object)that.mainChest)) && Objects.equal((Object)((Object)otherChest), (Object)((Object)that.getOtherChest()));
        }
        return Objects.equal((Object)((Object)this.mainChest), (Object)((Object)that.getOtherChest())) && Objects.equal((Object)((Object)otherChest), (Object)((Object)that.mainChest));
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean needsRefresh() {
        if (this == NO_ADJACENT_CHESTS_INSTANCE) {
            return false;
        }
        TileEntityAncientChestMP tileEntityChest = (TileEntityAncientChestMP)((Object)this.get());
        return tileEntityChest == null || tileEntityChest.func_145837_r();
    }

    public int getSlotLimit(int slot) {
        boolean accessingUpperChest = slot < 27;
        return this.getChest(accessingUpperChest).func_70297_j_();
    }
}

