/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.util.blocks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.util.blocks.BlockBaseMP;
import stevekung.mods.moreplanets.util.helper.BlockStateHelper;

public abstract class BlockLeavesMP
extends BlockBaseMP
implements IShearable {
    protected int[] surroundings;

    public BlockLeavesMP() {
        super(Material.field_151584_j);
        this.func_149675_a(true);
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.setSoundType(SoundType.field_185850_c);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        int l;
        int k;
        int b0 = 1;
        int i = b0 + 1;
        int j = pos.func_177958_n();
        if (world.func_175707_a(new BlockPos(j - i, (k = pos.func_177956_o()) - i, (l = pos.func_177952_p()) - i), new BlockPos(j + i, k + i, l + i))) {
            for (int i1 = -b0; i1 <= b0; ++i1) {
                for (int j1 = -b0; j1 <= b0; ++j1) {
                    for (int k1 = -b0; k1 <= b0; ++k1) {
                        BlockPos blockpos1 = pos.func_177982_a(i1, j1, k1);
                        IBlockState iblockstate1 = world.func_180495_p(blockpos1);
                        if (!iblockstate1.func_177230_c().isLeaves(iblockstate1, (IBlockAccess)world, blockpos1)) continue;
                        iblockstate1.func_177230_c().beginLeavesDecay(iblockstate1, world, blockpos1);
                    }
                }
            }
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)BlockStateHelper.CHECK_DECAY)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)BlockStateHelper.DECAYABLE)).booleanValue()) {
            int k1;
            int b0 = 4;
            int i = b0 + 1;
            int j = pos.func_177958_n();
            int k = pos.func_177956_o();
            int l = pos.func_177952_p();
            int b1 = 32;
            int i1 = b1 * b1;
            int j1 = b1 / 2;
            if (this.surroundings == null) {
                this.surroundings = new int[b1 * b1 * b1];
            }
            if (world.func_175707_a(new BlockPos(j - i, k - i, l - i), new BlockPos(j + i, k + i, l + i))) {
                int i2;
                int l1;
                for (k1 = -b0; k1 <= b0; ++k1) {
                    for (l1 = -b0; l1 <= b0; ++l1) {
                        for (i2 = -b0; i2 <= b0; ++i2) {
                            BlockPos tmp = new BlockPos(j + k1, k + l1, l + i2);
                            Block block = world.func_180495_p(tmp).func_177230_c();
                            if (!block.canSustainLeaves(world.func_180495_p(tmp), (IBlockAccess)world, tmp)) {
                                if (block.isLeaves(world.func_180495_p(tmp), (IBlockAccess)world, tmp)) {
                                    this.surroundings[(k1 + j1) * i1 + (l1 + j1) * b1 + i2 + j1] = -2;
                                    continue;
                                }
                                this.surroundings[(k1 + j1) * i1 + (l1 + j1) * b1 + i2 + j1] = -1;
                                continue;
                            }
                            this.surroundings[(k1 + j1) * i1 + (l1 + j1) * b1 + i2 + j1] = 0;
                        }
                    }
                }
                for (k1 = 1; k1 <= 4; ++k1) {
                    for (l1 = -b0; l1 <= b0; ++l1) {
                        for (i2 = -b0; i2 <= b0; ++i2) {
                            for (int j2 = -b0; j2 <= b0; ++j2) {
                                if (this.surroundings[(l1 + j1) * i1 + (i2 + j1) * b1 + j2 + j1] != k1 - 1) continue;
                                if (this.surroundings[(l1 + j1 - 1) * i1 + (i2 + j1) * b1 + j2 + j1] == -2) {
                                    this.surroundings[(l1 + j1 - 1) * i1 + (i2 + j1) * b1 + j2 + j1] = k1;
                                }
                                if (this.surroundings[(l1 + j1 + 1) * i1 + (i2 + j1) * b1 + j2 + j1] == -2) {
                                    this.surroundings[(l1 + j1 + 1) * i1 + (i2 + j1) * b1 + j2 + j1] = k1;
                                }
                                if (this.surroundings[(l1 + j1) * i1 + (i2 + j1 - 1) * b1 + j2 + j1] == -2) {
                                    this.surroundings[(l1 + j1) * i1 + (i2 + j1 - 1) * b1 + j2 + j1] = k1;
                                }
                                if (this.surroundings[(l1 + j1) * i1 + (i2 + j1 + 1) * b1 + j2 + j1] == -2) {
                                    this.surroundings[(l1 + j1) * i1 + (i2 + j1 + 1) * b1 + j2 + j1] = k1;
                                }
                                if (this.surroundings[(l1 + j1) * i1 + (i2 + j1) * b1 + j2 + j1 - 1] == -2) {
                                    this.surroundings[(l1 + j1) * i1 + (i2 + j1) * b1 + j2 + j1 - 1] = k1;
                                }
                                if (this.surroundings[(l1 + j1) * i1 + (i2 + j1) * b1 + j2 + j1 + 1] != -2) continue;
                                this.surroundings[(l1 + j1) * i1 + (i2 + j1) * b1 + j2 + j1 + 1] = k1;
                            }
                        }
                    }
                }
            }
            if ((k1 = this.surroundings[j1 * i1 + j1 * b1 + j1]) >= 0) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)BlockStateHelper.CHECK_DECAY, (Comparable)Boolean.valueOf(false)), 4);
            } else {
                this.destroy(world, pos);
            }
        }
    }

    protected void destroy(World world, BlockPos pos) {
        this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
        world.func_175698_g(pos);
    }

    public int func_149745_a(Random rand) {
        return rand.nextInt(20) == 0 ? 1 : 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return Blocks.field_150362_t.func_176225_a(state, world, pos, side);
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (world.func_175727_C(pos.func_177984_a()) && !world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) && rand.nextInt(15) == 1) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.DRIP_WATER, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        int chance = 20;
        if (fortune > 0 && (chance -= 2 << fortune) < 10) {
            chance = 10;
        }
        if (rand.nextInt(chance) == 0) {
            ret.add(new ItemStack(this.func_180660_a(state, rand, fortune), 1, this.func_180651_a(state)));
        }
        chance = 200;
        if (fortune > 0 && (chance -= 10 << fortune) < 40) {
            chance = 40;
        }
        this.captureDrops(true);
        if (world instanceof World) {
            this.dropFruits((World)world, pos, state, chance);
        }
        ret.addAll((Collection<ItemStack>)this.captureDrops(false));
        return ret;
    }

    public boolean isShearable(ItemStack itemStack, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)BlockStateHelper.CHECK_DECAY)).booleanValue()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)BlockStateHelper.CHECK_DECAY, (Comparable)Boolean.valueOf(true)), 4);
        }
    }

    protected void dropFruits(World world, BlockPos pos, IBlockState state, int chance) {
    }
}

