/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.util.EnumMCVersion;

public class VersionChecker
implements Runnable {
    private static boolean isLatest = false;
    private static boolean noConnection = false;
    private static String latestVersion = "";
    private static String exceptionMessage = "";
    private static List<String> changeLog = new ArrayList<String>();
    public static VersionChecker INSTANCE = new VersionChecker();

    public static void startCheck() {
        Thread thread = new Thread(INSTANCE);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String latestVersion;
        InputStream version = null;
        InputStream desc = null;
        try {
            version = new URL("https://raw.githubusercontent.com/SteveKunG/VersionCheckLibrary/master/more_planets/more_planets_version.txt").openStream();
            desc = new URL("https://raw.githubusercontent.com/SteveKunG/VersionCheckLibrary/master/more_planets/more_planets_desc.txt").openStream();
        }
        catch (MalformedURLException e) {
            exceptionMessage = e.getClass().getName() + " " + e.getMessage();
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            exceptionMessage = e.getClass().getName() + " " + e.getMessage();
            e.printStackTrace();
        }
        catch (Exception e) {
            exceptionMessage = e.getClass().getName() + " " + e.getMessage();
            e.printStackTrace();
        }
        if (version == null && desc == null) {
            noConnection = true;
            return;
        }
        try {
            for (EnumMCVersion mcVersion : EnumMCVersion.valuesCached()) {
                if (!MorePlanetsCore.MC_VERSION.equals(mcVersion.getVersion())) continue;
                VersionChecker.latestVersion = (String)IOUtils.readLines((InputStream)version, (Charset)StandardCharsets.UTF_8).get(mcVersion.getVersionIndex());
            }
            changeLog = IOUtils.readLines((InputStream)desc, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)version);
            IOUtils.closeQuietly((InputStream)desc);
        }
        int major = 0;
        int minor = 0;
        int build = 0;
        String latest = VersionChecker.latestVersion;
        if (latest.contains("[" + MorePlanetsCore.MC_VERSION + "]=")) {
            latest = latest.replace("[" + MorePlanetsCore.MC_VERSION + "]=", "").replace(".", "");
            try {
                major = Integer.parseInt(String.valueOf(latest.charAt(0)));
                minor = Integer.parseInt(String.valueOf(latest.charAt(1)));
                build = Integer.parseInt(String.valueOf(latest.charAt(2)));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        isLatest = !"2.0.21".equals(latestVersion = major + "." + minor + "." + build) && (major > 2 || minor > 0 || build > 21);
    }

    public boolean isLatestVersion() {
        return isLatest;
    }

    public boolean noConnection() {
        return noConnection;
    }

    public String getLatestVersion() {
        return latestVersion;
    }

    public String getExceptionMessage() {
        return exceptionMessage;
    }

    public List<String> getChangeLog() {
        return changeLog;
    }
}

