/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.tileentity;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.tile.FluidTankGC;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FluidHandlerWrapper;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import stevekung.mods.moreplanets.entity.EntityBlackHoleStorage;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.init.MPSounds;
import stevekung.mods.moreplanets.util.CompatibilityManagerMP;
import stevekung.mods.moreplanets.util.JsonUtil;
import stevekung.mods.moreplanets.util.tileentity.TileEntityAdvancedMP;

public class TileEntityBlackHoleStorage
extends TileEntityAdvancedMP
implements IFluidHandlerWrapper,
IConnector {
    private static final int[] SLOTS = new int[108];
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTankGC fluidTank = new FluidTankGC(1000000, (TileEntity)this);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean disableBlackHole = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean useHopper = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String ownerUUID = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int xp = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int xpTemp = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String collectMode = "item";
    public int renderTicks;
    public int modeInt;
    private boolean initialize = true;

    public TileEntityBlackHoleStorage() {
        super("container.black_hole_storage.name");
        this.inventory = NonNullList.func_191197_a((int)108, (Object)ItemStack.field_190927_a);
    }

    public void func_73660_a() {
        super.func_73660_a();
        ++this.renderTicks;
        if (this.initialize) {
            this.renderTicks += this.field_145850_b.field_73012_v.nextInt(100);
            this.initialize = false;
        }
        if (this.ticks % 20 == 0) {
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), MPSounds.BLACK_HOLE_AMBIENT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.updateStorage();
            List blackHoleList = this.field_145850_b.func_72872_a(EntityBlackHoleStorage.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 2), (double)this.field_174879_c.func_177952_p(), (double)this.field_174879_c.func_177958_n() + 1.0, (double)(this.field_174879_c.func_177956_o() + 3), (double)this.field_174879_c.func_177952_p() + 1.0));
            for (EntityBlackHoleStorage bh : blackHoleList) {
                bh.setDisable(this.disableBlackHole);
                bh.setCollectMode(this.collectMode);
            }
            if (blackHoleList.isEmpty()) {
                JsonUtil json = new JsonUtil();
                EntityPlayer player = this.field_145850_b.func_152378_a(UUID.fromString(this.ownerUUID));
                this.destroyBlock();
                if (player != null) {
                    player.func_145747_a(json.text(GCCoreUtil.translate((String)"gui.black_hole_disappear.message")).func_150255_a(json.red()));
                }
            }
            this.xpTemp = this.fluidTank.getFluidAmount();
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("XpFluid")) {
            this.fluidTank.readFromNBT(nbt.func_74775_l("XpFluid"));
        } else {
            NBTTagCompound fluidNbt = new NBTTagCompound();
            fluidNbt.func_74778_a("FluidName", "xpjuice");
            fluidNbt.func_74768_a("Amount", nbt.func_74762_e("XP"));
            this.fluidTank.readFromNBT(fluidNbt);
        }
        this.disableBlackHole = nbt.func_74767_n("DisableBlackHole");
        this.useHopper = nbt.func_74767_n("UseHopper");
        this.collectMode = nbt.func_74779_i("CollectMode");
        this.ownerUUID = nbt.func_74779_i("OwnerUUID");
        this.xp = nbt.func_74762_e("XP");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.ownerUUID != null) {
            nbt.func_74778_a("OwnerUUID", this.ownerUUID);
        }
        if (this.collectMode != null) {
            nbt.func_74778_a("CollectMode", this.collectMode);
        }
        if (this.fluidTank.getFluid() != null) {
            nbt.func_74782_a("XpFluid", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74757_a("DisableBlackHole", this.disableBlackHole);
        nbt.func_74757_a("UseHopper", this.useHopper);
        nbt.func_74768_a("XP", this.xp);
        return nbt;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack itemStack) {
        return itemStack.func_77973_b() != Item.func_150898_a((Block)MPBlocks.BLACK_HOLE_STORAGE);
    }

    public double getPacketRange() {
        return 32.0;
    }

    public boolean isNetworkedTile() {
        return true;
    }

    public int[] func_180463_a(EnumFacing facing) {
        return SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack itemStack, EnumFacing facing) {
        return this.useHopper;
    }

    public boolean func_180461_b(int index, ItemStack itemStack, EnumFacing facing) {
        return this.useHopper;
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper((IFluidHandlerWrapper)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (from == EnumFacing.UP) {
            return 0;
        }
        return this.fluidTank.fill(resource.copy(), doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (from == EnumFacing.UP) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (from == EnumFacing.UP) {
            return null;
        }
        return this.fluidTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (from == EnumFacing.UP) {
            return false;
        }
        return fluid == null || fluid.getName().equals("xpjuice");
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (from == EnumFacing.UP) {
            return false;
        }
        return fluid == null || this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() == fluid;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (from == EnumFacing.UP) {
            return new FluidTankInfo[0];
        }
        FluidTank compositeTank = new FluidTank(this.fluidTank.getCapacity());
        int capacity = this.fluidTank.getCapacity();
        compositeTank.setCapacity(capacity);
        return new FluidTankInfo[]{compositeTank.getInfo()};
    }

    public boolean canConnect(EnumFacing facing, NetworkType type) {
        return facing != EnumFacing.UP;
    }

    public int getMaxXP() {
        return 1000000;
    }

    public boolean drainExp(EntityPlayer player) {
        int xp;
        int requiredXp;
        int requiredXPJuice;
        FluidStack drained;
        FluidStack fluid = this.fluidTank.getFluid();
        boolean isXP = false;
        isXP = CompatibilityManagerMP.isModAddedXpFluid() ? fluid.isFluidEqual(new FluidStack(FluidRegistry.getFluid((String)"xpjuice"), 0)) : fluid.getFluid().getName().equals("xpjuice");
        if (fluid != null && isXP && (drained = this.fluidTank.drain(requiredXPJuice = this.xpToLiquidRatio(requiredXp = MathHelper.func_76123_f((float)((float)player.func_71050_bK() * (1.0f - player.field_71106_cc)))), false)) != null && (xp = this.liquidToXpRatio(drained.amount)) > 0) {
            int actualDrain = this.xpToLiquidRatio(xp);
            this.addPlayerXP(player, xp);
            this.fluidTank.drain(actualDrain, true);
            return true;
        }
        return false;
    }

    private int liquidToXpRatio(int liquid) {
        return liquid / 20;
    }

    private int xpToLiquidRatio(int xp) {
        return xp * 20;
    }

    private void addPlayerXP(EntityPlayer player, int amount) {
        int experience;
        player.field_71067_cb = experience = this.getPlayerXP(player) + amount;
        player.field_71068_ca = this.getLevelForExperience(experience);
        int expForLevel = this.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    private int getPlayerXP(EntityPlayer player) {
        return (int)((float)this.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    private int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return this.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + this.sum(level - 15, 37, 5);
        }
        return 1395 + this.sum(level - 30, 112, 9);
    }

    private int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = this.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }

    private int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    private int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    private boolean updateStorage() {
        if (!this.isFull()) {
            double range = 2.5;
            if (!this.disableBlackHole) {
                boolean collectAll = this.collectMode.equals("item_and_xp");
                if (this.collectMode.equals("item") || collectAll) {
                    for (EntityItem item : this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n() - range, (double)(this.func_174877_v().func_177956_o() + 2), (double)this.func_174877_v().func_177952_p() - range, (double)this.func_174877_v().func_177958_n() + range, (double)(this.func_174877_v().func_177956_o() + 4), (double)this.func_174877_v().func_177952_p() + range))) {
                        if (!this.putDropInInventoryAllSlots((IInventory)this, item)) continue;
                        return true;
                    }
                }
                if (this.collectMode.equals("xp") || collectAll) {
                    for (EntityXPOrb xp : this.field_145850_b.func_72872_a(EntityXPOrb.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n() - range, (double)(this.func_174877_v().func_177956_o() + 2), (double)this.func_174877_v().func_177952_p() - range, (double)this.func_174877_v().func_177958_n() + range, (double)(this.func_174877_v().func_177956_o() + 4), (double)this.func_174877_v().func_177952_p() + range))) {
                        if (!this.putXPValue(xp)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean isFull() {
        for (ItemStack itemStack : this.getInventory()) {
            if (!itemStack.func_190926_b() && itemStack.func_190916_E() == itemStack.func_77976_d()) continue;
            return false;
        }
        return this.fluidTank.getFluidAmount() < this.getMaxXP();
    }

    private boolean putXPValue(EntityXPOrb xpOrb) {
        if (xpOrb == null || this.fluidTank.getFluidAmount() >= this.getMaxXP()) {
            return false;
        }
        if (this.fluidTank.getFluidAmount() < this.fluidTank.getCapacity() - xpOrb.field_70530_e) {
            this.fluidTank.fill(new FluidStack(FluidRegistry.getFluid((String)"xpjuice"), xpOrb.field_70530_e), true);
            xpOrb.func_70106_y();
        }
        return true;
    }

    private boolean putDropInInventoryAllSlots(IInventory inventory, EntityItem entityItem) {
        boolean flag = false;
        if (entityItem == null) {
            return false;
        }
        ItemStack itemstack = entityItem.func_92059_d().func_77946_l();
        ItemStack itemstack1 = this.putStackInInventoryAllSlots(inventory, itemstack);
        if (!itemstack1.func_190926_b() && itemstack1.func_190916_E() != 0) {
            entityItem.func_92058_a(itemstack1);
        } else {
            flag = true;
            entityItem.func_70106_y();
        }
        return flag;
    }

    private ItemStack putStackInInventoryAllSlots(IInventory inventory, ItemStack itemStack) {
        int i = inventory.func_70302_i_();
        for (int index = 0; index < i && !itemStack.func_190926_b() && itemStack.func_190916_E() > 0; ++index) {
            itemStack = this.insertStack(inventory, itemStack, index);
        }
        if (!itemStack.func_190926_b() && itemStack.func_190916_E() == 0) {
            itemStack = ItemStack.field_190927_a;
        }
        return itemStack;
    }

    private ItemStack insertStack(IInventory inventory, ItemStack itemStack, int index) {
        ItemStack itemstack = inventory.func_70301_a(index);
        if (this.canInsertItemInSlot(inventory, itemStack, index)) {
            int max;
            boolean flag = false;
            if (itemstack.func_190926_b()) {
                int max2 = Math.min(itemStack.func_77976_d(), inventory.func_70297_j_());
                if (max2 >= itemStack.func_190916_E()) {
                    inventory.func_70299_a(index, itemStack);
                    itemStack = ItemStack.field_190927_a;
                } else {
                    inventory.func_70299_a(index, itemStack.func_77979_a(max2));
                }
                flag = true;
            } else if (this.canCombine(itemstack, itemStack) && (max = Math.min(itemStack.func_77976_d(), inventory.func_70297_j_())) > itemstack.func_190916_E()) {
                int i = max - itemstack.func_190916_E();
                int j = Math.min(itemStack.func_190916_E(), i);
                itemStack.func_190918_g(j);
                itemstack.func_190917_f(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                inventory.func_70296_d();
            }
        }
        return itemStack;
    }

    private boolean canInsertItemInSlot(IInventory inventory, ItemStack itemStack, int index) {
        return inventory.func_94041_b(index, itemStack);
    }

    private boolean canCombine(ItemStack itemStack1, ItemStack itemStack2) {
        return itemStack1.func_77973_b() != itemStack2.func_77973_b() ? false : (itemStack1.func_77960_j() != itemStack2.func_77960_j() ? false : (itemStack1.func_190916_E() > itemStack1.func_77976_d() ? false : ItemStack.func_77970_a((ItemStack)itemStack1, (ItemStack)itemStack2)));
    }

    private boolean destroyBlock() {
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = iblockstate.func_177230_c();
        if (block.isAir(iblockstate, (IBlockAccess)this.field_145850_b, this.field_174879_c)) {
            return false;
        }
        this.field_145850_b.func_175718_b(2001, this.field_174879_c, Block.func_176210_f((IBlockState)iblockstate));
        ItemStack itemStack = new ItemStack(MPBlocks.BLACK_HOLE_STORAGE);
        NBTTagCompound nbt = new NBTTagCompound();
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, (NonNullList)this.getInventory());
        nbt.func_74757_a("Disable", this.disableBlackHole);
        nbt.func_74757_a("Hopper", this.useHopper);
        nbt.func_74778_a("Mode", this.collectMode);
        if (this.fluidTank.getFluid() != null) {
            NBTTagCompound fluidNbt = new NBTTagCompound();
            fluidNbt.func_74778_a("FluidName", "xpjuice");
            fluidNbt.func_74768_a("Amount", this.fluidTank.getFluidAmount());
            nbt.func_74782_a("XpFluid", (NBTBase)fluidNbt);
        }
        itemStack.func_77982_d(nbt);
        Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)itemStack);
        return this.field_145850_b.func_180501_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P(), 3);
    }

    static {
        int i = 0;
        while (i < SLOTS.length) {
            TileEntityBlackHoleStorage.SLOTS[i] = i++;
        }
    }
}

