/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.client.renderer.tileentity;

import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import stevekung.mods.moreplanets.module.planets.nibiru.tileentity.TileEntityMultalicCrystal;
import stevekung.mods.moreplanets.util.client.model.ModelCrystal;
import stevekung.mods.moreplanets.util.helper.ColorHelper;

public class TileEntityMultalicCrystalRenderer
extends TileEntitySpecialRenderer<TileEntityMultalicCrystal> {
    private ModelCrystal model = new ModelCrystal();
    public static final TileEntityMultalicCrystalRenderer INSTANCE = new TileEntityMultalicCrystalRenderer();

    public void render(TileEntityMultalicCrystal tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (tile.facing == null) {
            return;
        }
        Random rand = new Random(tile.func_174877_v().func_177958_n() + tile.func_174877_v().func_177956_o() * tile.func_174877_v().func_177952_p());
        for (int i = 0; i < 4; ++i) {
            int angle2;
            int angle1;
            int spike;
            int[] colorList = new int[]{ColorHelper.rgbToDecimal(76, 132, 255), ColorHelper.rgbToDecimal(50, 101, 236), ColorHelper.rgbToDecimal(75, 131, 255), ColorHelper.rgbToDecimal(28, 60, 146)};
            for (spike = 0; spike < 2; ++spike) {
                angle1 = rand.nextInt(16) + 160 * spike;
                angle2 = 8 + rand.nextInt(16);
                this.drawCrystal(tile, (float)x, (float)y, (float)z, angle1, angle2, rand, colorList[i], 1.15f);
            }
            for (spike = 0; spike < 2; ++spike) {
                angle1 = rand.nextInt(74) + 232 * spike;
                angle2 = 3 + rand.nextInt(24);
                this.drawCrystal(tile, (float)x, (float)y, (float)z, angle1, angle2, rand, colorList[i], 1.15f);
            }
        }
    }

    private void drawCrystal(TileEntityMultalicCrystal tile, float x, float y, float z, float angle1, float angle2, Random rand, int color, float size) {
        float shade = MathHelper.func_76126_a((float)((float)(tile.renderTicks + rand.nextInt(1)) / (8.0f + rand.nextFloat()))) * 0.2f + 1.0f;
        Color c = new Color(color);
        float r = (float)c.getRed() / 200.0f;
        float g = (float)c.getGreen() / 200.0f;
        float b = (float)c.getBlue() / 200.0f;
        int shadeLight = (int)(200.0f * shade);
        int lightX = shadeLight % 65536;
        int lightZ = shadeLight / 65536;
        float lightMapSaveX = OpenGlHelper.lastBrightnessX;
        float lightMapSaveY = OpenGlHelper.lastBrightnessY;
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179108_z();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179109_b((float)(x + 0.5f), (float)y, (float)(z + 0.5f));
        this.translateFromDirection(tile);
        GlStateManager.func_179114_b((float)angle1, (float)0.1f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)angle2, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)((0.15f + rand.nextFloat() * 0.075f) * size), (float)((0.5f + rand.nextFloat() * 0.1f) * size), (float)((0.15f + rand.nextFloat() * 0.05f) * size));
        if (tile.renderTicks > 0) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)lightX / 1.0f), (float)((float)lightZ / 1.0f));
        }
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)0.75f);
        this.func_147499_a(new ResourceLocation("moreplanets:textures/model/crystal.png"));
        this.model.render();
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapSaveX, (float)lightMapSaveY);
    }

    private void translateFromDirection(TileEntityMultalicCrystal tile) {
        switch (tile.facing) {
            case WEST: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.7f);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)-0.7f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case UP: {
                GlStateManager.func_179109_b((float)-0.7f, (float)0.575f, (float)0.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case NORTH: {
                GlStateManager.func_179109_b((float)0.7f, (float)0.5f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.3f, (float)0.0f);
                break;
            }
            default: {
                GlStateManager.func_179109_b((float)0.0f, (float)1.3f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
    }

    public void render() {
        Random rand = new Random(4L);
        for (int i = 0; i < 4; ++i) {
            int angle2;
            int angle1;
            int spike;
            int[] colorList = new int[]{ColorHelper.rgbToDecimal(76, 132, 255), ColorHelper.rgbToDecimal(50, 101, 236), ColorHelper.rgbToDecimal(75, 131, 255), ColorHelper.rgbToDecimal(28, 60, 146)};
            for (spike = 0; spike < 2; ++spike) {
                angle1 = rand.nextInt(16) + 160 * spike;
                angle2 = 8 + rand.nextInt(16);
                this.drawCrystal(angle1, angle2, rand, colorList[i], 1.15f);
            }
            for (spike = 0; spike < 2; ++spike) {
                angle1 = rand.nextInt(74) + 232 * spike;
                angle2 = 3 + rand.nextInt(24);
                this.drawCrystal(angle1, angle2, rand, colorList[i], 1.15f);
            }
        }
    }

    private void drawCrystal(float angle1, float angle2, Random rand, int color, float size) {
        Color c = new Color(color);
        float r = (float)c.getRed() / 200.0f;
        float g = (float)c.getGreen() / 200.0f;
        float b = (float)c.getBlue() / 200.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179108_z();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179109_b((float)0.475f, (float)-0.3f, (float)0.5f);
        GlStateManager.func_179114_b((float)angle1, (float)0.1f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)angle2, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)((0.15f + rand.nextFloat() * 0.075f) * size), (float)((0.5f + rand.nextFloat() * 0.1f) * size), (float)((0.15f + rand.nextFloat() * 0.05f) * size));
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)0.75f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("moreplanets:textures/model/crystal.png"));
        this.model.render();
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179147_l();
    }
}

