/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.chalos.dimension;

import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.init.MPDimensions;
import stevekung.mods.moreplanets.init.MPPlanets;
import stevekung.mods.moreplanets.module.planets.chalos.blocks.ChalosBlocks;
import stevekung.mods.moreplanets.module.planets.chalos.client.sky.SkyProviderChalos;
import stevekung.mods.moreplanets.module.planets.chalos.world.gen.BiomeProviderChalos;
import stevekung.mods.moreplanets.module.planets.chalos.world.gen.ChunkGeneratorChalos;
import stevekung.mods.moreplanets.util.dimension.WorldProviderMP;

public class WorldProviderChalos
extends WorldProviderMP {
    @Override
    public Vector3 getFogColor() {
        float f = 0.65f - this.getStarBrightness(1.0f);
        return new Vector3((double)(1.0f * f), (double)(0.75686276f * f), (double)(0.023529412f * f));
    }

    @Override
    public Vector3 getSkyColor() {
        float f = 0.6f - this.getStarBrightness(1.0f);
        return new Vector3((double)(1.0f * f), (double)(0.8745098f * f), (double)(0.5019608f * f));
    }

    @Override
    public boolean hasSunset() {
        return true;
    }

    public long getDayLength() {
        return 48000L;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float partialTicks) {
        float angle = this.field_76579_a.func_72826_c(partialTicks);
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (value < 0.0f) {
            value = 0.0f;
        }
        if (value > 1.0f) {
            value = 1.0f;
        }
        return value * value * 0.4f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float partialTicks) {
        float angle = this.field_76579_a.func_72826_c(partialTicks);
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (value < 0.0f) {
            value = 0.0f;
        }
        if (value > 1.025f) {
            value = 1.025f;
        }
        value = 1.0f - value;
        return value * 1.0f;
    }

    public double getSolarEnergyMultiplier() {
        return 1.5;
    }

    public float getGravity() {
        return 0.027f;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= 5;
    }

    public float getFallDamageModifier() {
        return 0.75f;
    }

    public CelestialBody getCelestialBody() {
        return MPPlanets.CHALOS;
    }

    public float getThermalLevelModifier() {
        float angle = this.field_76579_a.func_72826_c((float)this.getDayLength());
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        value = 1.0f - value;
        return value * 1.0f;
    }

    @Override
    public float getArrowGravity() {
        return 0.035f;
    }

    @Override
    public int getDarkEnergyMultiplier(World world, BlockPos pos) {
        return pos.func_177956_o();
    }

    @Override
    protected void renderSky() {
        this.setSkyRenderer(new SkyProviderChalos((IGalacticraftWorldProvider)this));
    }

    @Override
    protected void renderCloud() {
        this.setCloudRenderer((IRenderHandler)new CloudRenderer());
    }

    @Override
    protected void renderWeather() {
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)this.getCelestialBody());
        return BiomeProviderChalos.class;
    }

    @Override
    public void func_76572_b() {
        this.field_76578_c = new BiomeProviderChalos(this.field_76579_a.func_72905_C());
    }

    @Override
    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorChalos(this.field_76579_a, this.field_76579_a.func_72905_C());
    }

    public DimensionType func_186058_p() {
        return MPDimensions.CHALOS;
    }

    public List<Block> getSurfaceBlocks() {
        return Arrays.asList(ChalosBlocks.CHEESE_GRASS, ChalosBlocks.CHEESE_DIRT, ChalosBlocks.CHALOS_BLOCK);
    }
}

