/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.util.world.gen.dungeon;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import stevekung.mods.moreplanets.util.MPLog;
import stevekung.mods.moreplanets.util.world.gen.dungeon.DungeonConfigurationMP;
import stevekung.mods.moreplanets.util.world.gen.dungeon.DungeonStartMP;
import stevekung.mods.moreplanets.util.world.gen.dungeon.PieceMP;
import stevekung.mods.moreplanets.util.world.gen.dungeon.SizedPieceMP;

public class RoomEntranceMP
extends SizedPieceMP {
    private int range = 4;

    public RoomEntranceMP() {
    }

    public RoomEntranceMP(World world, DungeonConfigurationMP configuration, Random rand, int blockPosX, int blockPosZ) {
        super(configuration, rand.nextInt(4) + 6, rand.nextInt(2) + 5, rand.nextInt(4) + 6, EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
        this.func_186164_a(EnumFacing.SOUTH);
        this.field_74887_e = new StructureBoundingBox(blockPosX - this.range, configuration.getYPosition(), blockPosZ - this.range, blockPosX + this.range, 150, blockPosZ + this.range);
        MPLog.debug("Generating boss dungeon at x:{} y:{} z:{}", blockPosX, configuration.getYPosition() + 1, blockPosZ);
    }

    public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
        int i;
        int maxLevel = 0;
        for (int i2 = -this.range; i2 <= this.range; ++i2) {
            for (int k = -this.range; k <= this.range; ++k) {
                Block block;
                int j = this.field_74887_e.func_78882_c();
                while (j >= 0 && (Blocks.field_150350_a == (block = this.func_175807_a(worldIn, i2 + this.range, --j, k + this.range, this.field_74887_e).func_177230_c()) || block == null)) {
                }
                maxLevel = Math.max(maxLevel, j + 3);
            }
        }
        int startX = this.range - this.sizeX / 2;
        int startZ = this.range - this.sizeZ / 2;
        int endX = this.range + this.sizeX / 2;
        int endZ = this.range + this.sizeZ / 2;
        for (i = startX; i <= endX; ++i) {
            for (int j = 0; j <= this.sizeY; ++j) {
                for (int k = startZ; k <= endZ; ++k) {
                    if (i == startX || i == endX || j == 0 || j == this.sizeY || k == startZ || k == endZ) {
                        this.func_175811_a(worldIn, this.configuration.getBrickBlock(), i, j, k, this.field_74887_e);
                        continue;
                    }
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, this.field_74887_e);
                }
            }
        }
        for (i = -this.range; i < this.range; ++i) {
            for (int k = -this.range; k < this.range; ++k) {
                double xDev = (double)i / 10.0;
                double zDev = (double)k / 10.0;
                double distance = xDev * xDev + zDev * zDev;
                int depth = (int)Math.abs(0.5 / (distance + 1.0E-5));
                int helper = 0;
                for (int j = maxLevel; j > 1 && helper <= depth; --j) {
                    IBlockState block1 = this.func_175807_a(worldIn, i + this.range, j, k + this.range, this.field_74887_e);
                    if (block1 != this.configuration.getBrickBlock() && j == this.sizeY) continue;
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i + this.range, j, k + this.range, this.field_74887_e);
                    ++helper;
                }
            }
        }
        return true;
    }

    @Override
    public PieceMP getNextPiece(DungeonStartMP startPiece, Random rand) {
        if (startPiece.attachedComponents.isEmpty()) {
            return this.getCorridor(rand, startPiece, 10, false);
        }
        return null;
    }

    @Override
    protected StructureBoundingBox getExtension(EnumFacing direction, int length, int width) {
        int blockZ;
        int blockX;
        int sizeZ;
        int sizeX;
        int startX = this.field_74887_e.field_78897_a + this.range - this.sizeX / 2;
        int startZ = this.field_74887_e.field_78896_c + this.range - this.sizeZ / 2;
        int endX = this.field_74887_e.field_78897_a + this.range + this.sizeX / 2;
        int endZ = this.field_74887_e.field_78896_c + this.range + this.sizeZ / 2;
        switch (direction) {
            case NORTH: {
                sizeX = width;
                sizeZ = length;
                blockX = startX + (endX - startX) / 2 - sizeX / 2;
                blockZ = startZ - sizeZ;
                break;
            }
            case EAST: {
                sizeX = length;
                sizeZ = width;
                blockX = endX;
                blockZ = startZ + (endZ - startZ) / 2 - sizeZ / 2;
                break;
            }
            case SOUTH: {
                sizeX = width;
                sizeZ = length;
                blockX = startX + (endX - startX) / 2 - sizeX / 2;
                blockZ = endZ;
                break;
            }
            default: {
                sizeX = length;
                sizeZ = width;
                blockX = startX - sizeX;
                blockZ = startZ + (endZ - startZ) / 2 - sizeZ / 2;
            }
        }
        return new StructureBoundingBox(blockX, blockZ, blockX + sizeX, blockZ + sizeZ);
    }
}

