/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.util.world.gen;

import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.perlin.NoiseModule;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.world.gen.EnumCraterSize;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorOverworld;

public abstract class ChunkProviderBaseMP
extends ChunkGeneratorOverworld {
    protected NoiseModule noiseGen1;
    protected NoiseModule noiseGen2;
    protected NoiseModule noiseGen3;
    protected NoiseModule noiseGen4;
    protected World worldObj;
    protected Random field_185990_i;
    private int CHUNK_SIZE_X = 16;
    private int CHUNK_SIZE_Y = 128;
    private int CHUNK_SIZE_Z = 16;

    public ChunkProviderBaseMP(World world, long seed) {
        super(world, seed, true, "");
        this.worldObj = world;
        this.field_185990_i = new Random(seed);
        this.noiseGen1 = new Gradient(this.field_185990_i.nextLong(), 4, 0.25f);
        this.noiseGen2 = new Gradient(this.field_185990_i.nextLong(), 4, 0.25f);
        this.noiseGen3 = new Gradient(this.field_185990_i.nextLong(), 1, 0.25f);
        this.noiseGen4 = new Gradient(this.field_185990_i.nextLong(), 1, 0.25f);
    }

    public void generateTerrain(int chunkX, int chunkZ, ChunkPrimer chunk) {
        this.noiseGen1.setFrequency(0.0125f);
        this.noiseGen2.setFrequency(0.015f);
        this.noiseGen3.setFrequency(0.01f);
        this.noiseGen4.setFrequency(0.02f);
        for (int x = 0; x < this.CHUNK_SIZE_X; ++x) {
            for (int z = 0; z < this.CHUNK_SIZE_Z; ++z) {
                double d = this.noiseGen1.getNoise((float)(x + chunkX * 16), (float)(z + chunkZ * 16)) * 8.0f;
                double d2 = this.noiseGen2.getNoise((float)(x + chunkX * 16), (float)(z + chunkZ * 16)) * 24.0f;
                double d3 = (double)this.noiseGen3.getNoise((float)(x + chunkX * 16), (float)(z + chunkZ * 16)) - 0.1;
                double yDev = 0.0;
                yDev = d3 < 0.0 ? d : (d3 > 1.0 ? d2 : d + (d2 - d) * (d3 *= 4.0));
                for (int y = 0; y < this.CHUNK_SIZE_Y; ++y) {
                    if (!((double)y < (double)this.getTerrainHeight() + yDev)) continue;
                    chunk.func_177855_a(x, y, z, this.getBaseBlock().func_176203_a(this.getBlockMetadata()[2]));
                }
            }
        }
    }

    public void func_185977_a(int chunkX, int chunkZ, ChunkPrimer chunk, Biome[] biomeGen) {
        int var5 = 20;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int noise = (int)((double)this.noiseGen4.getNoise((float)(x + chunkX * 16), (float)(z * chunkZ * 16)) / 3.0 + 3.0 + this.field_185990_i.nextDouble() * 0.25);
                int var13 = -1;
                Block topBlock = this.getBaseBlock();
                int topBlockMeta = this.getBlockMetadata()[0];
                Block fillBlock = this.getBaseBlock();
                int fillBlockMeta = this.getBlockMetadata()[1];
                for (int y = 255; y >= 0; --y) {
                    if (y <= 0 + this.field_185990_i.nextInt(5)) {
                        chunk.func_177855_a(x, y, z, Blocks.field_150357_h.func_176223_P());
                        continue;
                    }
                    Block block = chunk.func_177856_a(x, y, z).func_177230_c();
                    if (Blocks.field_150350_a == block) {
                        var13 = -1;
                        continue;
                    }
                    if (block != this.getBaseBlock()) continue;
                    if (var13 == -1) {
                        if (noise <= 0) {
                            topBlock = Blocks.field_150350_a;
                            topBlockMeta = 0;
                            fillBlock = this.getBaseBlock();
                            fillBlockMeta = this.getBlockMetadata()[1];
                        } else if (y >= var5 - -16 && y <= var5 + 1) {
                            topBlock = this.getBaseBlock();
                            topBlockMeta = this.getBlockMetadata()[0];
                            topBlock = this.getBaseBlock();
                            topBlockMeta = this.getBlockMetadata()[1];
                        }
                        var13 = noise;
                        if (y >= var5 - 1) {
                            chunk.func_177855_a(x, y, z, topBlock.func_176203_a(topBlockMeta));
                            continue;
                        }
                        if (y >= var5 - 1 || y < var5 - 2) continue;
                        chunk.func_177855_a(x, y, z, fillBlock.func_176203_a(fillBlockMeta));
                        continue;
                    }
                    if (var13 <= 0) continue;
                    --var13;
                    chunk.func_177855_a(x, y, z, fillBlock.func_176203_a(fillBlockMeta));
                }
            }
        }
    }

    public void createCraters(int chunkX, int chunkZ, ChunkPrimer chunk) {
        for (int cx = chunkX - 2; cx <= chunkX + 2; ++cx) {
            for (int cz = chunkZ - 2; cz <= chunkZ + 2; ++cz) {
                for (int x = 0; x < this.CHUNK_SIZE_X; ++x) {
                    for (int z = 0; z < this.CHUNK_SIZE_Z; ++z) {
                        if (this.getCraterChance() <= 0 || !(Math.abs(this.randFromPoint(cx * 16 + x, (cz * 16 + z) * 1000)) < (double)(this.noiseGen4.getNoise((float)(x * this.CHUNK_SIZE_X + x), (float)(cz * this.CHUNK_SIZE_Z + z)) / (float)this.getCraterChance()))) continue;
                        Random random = new Random(cx * 16 + x + (cz * 16 + z) * 5000);
                        EnumCraterSize cSize = EnumCraterSize.sizeArray[random.nextInt(EnumCraterSize.sizeArray.length)];
                        int size = random.nextInt(cSize.MAX_SIZE - cSize.MIN_SIZE) + cSize.MIN_SIZE;
                        this.makeCrater(cx * 16 + x, cz * 16 + z, chunkX * 16, chunkZ * 16, size, chunk);
                    }
                }
            }
        }
    }

    public void makeCrater(int craterX, int craterZ, int chunkX, int chunkZ, int size, ChunkPrimer chunk) {
        for (int x = 0; x < this.CHUNK_SIZE_X; ++x) {
            block1: for (int z = 0; z < this.CHUNK_SIZE_Z; ++z) {
                double xDev = craterX - (chunkX + x);
                double zDev = craterZ - (chunkZ + z);
                if (!(xDev * xDev + zDev * zDev < (double)(size * size))) continue;
                double sqrtY = (xDev /= (double)size) * xDev + (zDev /= (double)size) * zDev;
                double yDev = sqrtY * sqrtY * 6.0;
                yDev = 5.0 - yDev;
                int helper = 0;
                for (int y = 127; y > 0; --y) {
                    if (Blocks.field_150350_a != chunk.func_177856_a(x, y, z).func_177230_c() && (double)helper <= yDev) {
                        chunk.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
                        ++helper;
                    }
                    if ((double)helper > yDev) continue block1;
                }
            }
        }
    }

    private double randFromPoint(int x, int z) {
        int n = x + z * 57;
        n = n << 13 ^ n;
        return 1.0 - (double)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.073741824E9;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType type, BlockPos pos) {
        return this.worldObj.func_180494_b(pos).func_76747_a(type);
    }

    protected int getCraterChance() {
        return 300;
    }

    protected int getTerrainHeight() {
        return 64;
    }

    protected abstract Block getBaseBlock();

    protected abstract int[] getBlockMetadata();
}

