/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.util.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.util.blocks.BlockBaseMP;
import stevekung.mods.moreplanets.util.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.util.helper.BlockStateHelper;

public abstract class BlockCakeMP
extends BlockBaseMP {
    protected static AxisAlignedBB[] CAKE_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.5, 0.9375), new AxisAlignedBB(0.1875, 0.0, 0.0625, 0.9375, 0.5, 0.9375), new AxisAlignedBB(0.3125, 0.0, 0.0625, 0.9375, 0.5, 0.9375), new AxisAlignedBB(0.4375, 0.0, 0.0625, 0.9375, 0.5, 0.9375), new AxisAlignedBB(0.5625, 0.0, 0.0625, 0.9375, 0.5, 0.9375), new AxisAlignedBB(0.6875, 0.0, 0.0625, 0.9375, 0.5, 0.9375), new AxisAlignedBB(0.8125, 0.0, 0.0625, 0.9375, 0.5, 0.9375)};

    public BlockCakeMP() {
        super(Material.field_151568_F);
        this.func_149675_a(true);
        this.func_149711_c(0.5f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)BlockStateHelper.BITES, (Comparable)Integer.valueOf(0)));
        this.setSoundType(SoundType.field_185854_g);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return CAKE_AABB[(Integer)state.func_177229_b((IProperty)BlockStateHelper.BITES)];
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return state.func_185890_d((IBlockAccess)world, pos);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float x, float y, float z) {
        this.eatCake(world, pos, state, player);
        return true;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        this.eatCake(world, pos, world.func_180495_p(pos), player);
    }

    private void eatCake(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!player.func_71043_e(false)) {
            return;
        }
        player.func_71024_bL().func_75122_a(this.getFoodAmount(), this.getSaturationAmount());
        int i = (Integer)state.func_177229_b((IProperty)BlockStateHelper.BITES);
        if (i < 6) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)BlockStateHelper.BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            world.func_175698_g(pos);
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        if (super.func_176196_c(world, pos)) {
            return this.canBlockStay(world, pos);
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.canBlockStay(world, pos)) {
            world.func_175698_g(pos);
        }
    }

    private boolean canBlockStay(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a();
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, 0);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockStateHelper.BITES, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockStateHelper.BITES);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockStateHelper.BITES});
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return (7 - (Integer)state.func_177229_b((IProperty)BlockStateHelper.BITES)) * 2;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory(int meta) {
        return EnumSortCategoryBlock.CAKE;
    }

    protected abstract int getFoodAmount();

    protected abstract float getSaturationAmount();
}

