/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import stevekung.mods.moreplanets.util.VariantsName;
import stevekung.mods.moreplanets.util.blocks.BlockFenceMP;
import stevekung.mods.moreplanets.util.blocks.IBlockVariants;

public class BlockNibiruFence
extends BlockFenceMP
implements IBlockVariants {
    public static PropertyEnum<BlockType> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockType.class);

    public BlockNibiruFence(String name) {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)field_176526_a, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176525_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176527_M, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176528_N, (Comparable)Boolean.valueOf(false)).func_177226_a(VARIANT, (Comparable)((Object)BlockType.INFECTED_FENCE)));
        this.func_149663_c(name);
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int i = 0; i < BlockType.valuesCached().length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176526_a, field_176525_b, field_176528_N, field_176527_M, VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.valuesCached()[meta % BlockType.valuesCached().length]));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)field_176526_a, (Comparable)Boolean.valueOf(this.canFenceConnectTo(world, pos, EnumFacing.NORTH))).func_177226_a((IProperty)field_176525_b, (Comparable)Boolean.valueOf(this.canFenceConnectTo(world, pos, EnumFacing.EAST))).func_177226_a((IProperty)field_176527_M, (Comparable)Boolean.valueOf(this.canFenceConnectTo(world, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)field_176528_N, (Comparable)Boolean.valueOf(this.canFenceConnectTo(world, pos, EnumFacing.WEST)));
    }

    @Override
    public VariantsName getVariantsName() {
        return new VariantsName("infected", "infected_dead_oak", "alien_berry_oak");
    }

    private boolean canFenceConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos other = pos.func_177972_a(facing);
        Block block = world.func_180495_p(other).func_177230_c();
        return block.canBeConnectedTo(world, other, facing.func_176734_d()) || this.func_176524_e(world, other, facing.func_176734_d());
    }

    public static enum BlockType implements IStringSerializable
    {
        INFECTED_FENCE,
        INFECTED_DEAD_OAK_FENCE,
        ALIEN_BERRY_OAK_FENCE;

        private static BlockType[] values;

        public static BlockType[] valuesCached() {
            return values;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            values = BlockType.values();
        }
    }
}

