/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.world.gen.structure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import stevekung.mods.moreplanets.init.MPBiomes;
import stevekung.mods.moreplanets.init.MPLootTables;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.BlockHalfInfectedStoneBricksSlab;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.BlockNibiru;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.NibiruBlocks;
import stevekung.mods.moreplanets.module.planets.nibiru.entity.EntityNibiruVillager;
import stevekung.mods.moreplanets.util.blocks.BlockChestMP;
import stevekung.mods.moreplanets.util.blocks.BlockCropsMP;
import stevekung.mods.moreplanets.util.tileentity.TileEntityChestMP;

public class StructureNibiruVillagePieces {
    private static Stones villageStones = new Stones();
    private static Planks villagePlanks = new Planks();
    private static Logs villageLogs = new Logs();
    private static Dirts villageDirts = new Dirts();

    public static void registerVillagePieces() {
        MapGenStructureIO.func_143031_a(House1.class, (String)"NibiruViBH");
        MapGenStructureIO.func_143031_a(Field1.class, (String)"NibiruViDF");
        MapGenStructureIO.func_143031_a(Field2.class, (String)"NibiruViF");
        MapGenStructureIO.func_143031_a(Torch.class, (String)"NibiruViL");
        MapGenStructureIO.func_143031_a(Hall.class, (String)"NibiruViPH");
        MapGenStructureIO.func_143031_a(House4Garden.class, (String)"NibiruViSH");
        MapGenStructureIO.func_143031_a(WoodHut.class, (String)"NibiruViSmH");
        MapGenStructureIO.func_143031_a(Church.class, (String)"NibiruViST");
        MapGenStructureIO.func_143031_a(House2.class, (String)"NibiruViS");
        MapGenStructureIO.func_143031_a(Start.class, (String)"NibiruViStart");
        MapGenStructureIO.func_143031_a(Path.class, (String)"NibiruViSR");
        MapGenStructureIO.func_143031_a(House3.class, (String)"NibiruViTRH");
        MapGenStructureIO.func_143031_a(Well.class, (String)"NibiruViW");
    }

    public static List<PieceWeight> getStructureVillageWeightedPieceList(Random rand, int size) {
        ArrayList<PieceWeight> list = new ArrayList<PieceWeight>();
        list.add(new PieceWeight(House4Garden.class, 4, MathHelper.func_76136_a((Random)rand, (int)(2 + size), (int)(4 + size * 2))));
        list.add(new PieceWeight(Church.class, 20, MathHelper.func_76136_a((Random)rand, (int)(0 + size), (int)(1 + size))));
        list.add(new PieceWeight(House1.class, 20, MathHelper.func_76136_a((Random)rand, (int)(0 + size), (int)(2 + size))));
        list.add(new PieceWeight(WoodHut.class, 3, MathHelper.func_76136_a((Random)rand, (int)(2 + size), (int)(5 + size * 3))));
        list.add(new PieceWeight(Hall.class, 15, MathHelper.func_76136_a((Random)rand, (int)(0 + size), (int)(2 + size))));
        list.add(new PieceWeight(Field1.class, 3, MathHelper.func_76136_a((Random)rand, (int)(1 + size), (int)(4 + size))));
        list.add(new PieceWeight(Field2.class, 3, MathHelper.func_76136_a((Random)rand, (int)(2 + size), (int)(4 + size * 2))));
        list.add(new PieceWeight(House2.class, 15, MathHelper.func_76136_a((Random)rand, (int)0, (int)(1 + size))));
        list.add(new PieceWeight(House3.class, 8, MathHelper.func_76136_a((Random)rand, (int)(0 + size), (int)(3 + size * 2))));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (((PieceWeight)iterator.next()).villagePiecesLimit != 0) continue;
            iterator.remove();
        }
        return list;
    }

    static class Dirts
    extends StructureComponent.BlockSelector {
        private Dirts() {
        }

        public void func_75062_a(Random rand, int x, int y, int z, boolean wall) {
            float f;
            this.field_151562_a = wall ? ((f = rand.nextFloat()) < 0.2f ? NibiruBlocks.INFECTED_DIRT.func_176203_a(1) : (f < 0.4f ? NibiruBlocks.INFECTED_VINES_DIRT.func_176223_P() : NibiruBlocks.INFECTED_DIRT.func_176223_P())) : Blocks.field_150350_a.func_176223_P();
        }
    }

    static class Logs
    extends StructureComponent.BlockSelector {
        private Logs() {
        }

        public void func_75062_a(Random rand, int x, int y, int z, boolean wall) {
            float f;
            this.field_151562_a = wall ? ((f = rand.nextFloat()) < 0.05f ? Blocks.field_150321_G.func_176223_P() : (f < 0.1f ? NibiruBlocks.INFECTED_VINES.func_176203_a(15) : (f < 0.125f ? Blocks.field_150350_a.func_176223_P() : (f < 0.5f ? NibiruBlocks.NIBIRU_LOG.func_176223_P() : NibiruBlocks.NIBIRU_LOG.func_176223_P())))) : Blocks.field_150350_a.func_176223_P();
        }
    }

    static class Planks
    extends StructureComponent.BlockSelector {
        private Planks() {
        }

        public void func_75062_a(Random rand, int x, int y, int z, boolean wall) {
            float f;
            this.field_151562_a = wall ? ((f = rand.nextFloat()) < 0.05f ? Blocks.field_150321_G.func_176223_P() : (f < 0.1f ? NibiruBlocks.INFECTED_VINES.func_176203_a(15) : (f < 0.125f ? Blocks.field_150350_a.func_176223_P() : (f < 0.5f ? NibiruBlocks.NIBIRU_PLANKS.func_176223_P() : NibiruBlocks.NIBIRU_PLANKS.func_176223_P())))) : Blocks.field_150350_a.func_176223_P();
        }
    }

    static class Stones
    extends StructureComponent.BlockSelector {
        private Stones() {
        }

        public void func_75062_a(Random rand, int x, int y, int z, boolean wall) {
            float f;
            this.field_151562_a = wall ? ((f = rand.nextFloat()) < 0.05f ? Blocks.field_150321_G.func_176223_P() : (f < 0.1f ? NibiruBlocks.INFECTED_VINES.func_176203_a(15) : (f < 0.125f ? Blocks.field_150350_a.func_176223_P() : (f < 0.5f ? NibiruBlocks.NIBIRU_BLOCK.func_176223_P().func_177226_a(BlockNibiru.VARIANT, (Comparable)((Object)BlockNibiru.BlockType.NIBIRU_VEIN_COBBLESTONE)) : NibiruBlocks.NIBIRU_BLOCK.func_176223_P().func_177226_a(BlockNibiru.VARIANT, (Comparable)((Object)BlockNibiru.BlockType.NIBIRU_COBBLESTONE)))))) : Blocks.field_150350_a.func_176223_P();
        }
    }

    public static class WoodHut
    extends Village {
        private boolean isTallHouse;
        private int tablePosition;

        public WoodHut() {
        }

        public WoodHut(Start start, int type, Random rand, StructureBoundingBox box, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = box;
            this.isTallHouse = rand.nextBoolean();
            this.tablePosition = rand.nextInt(3);
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74768_a("T", this.tablePosition);
            nbt.func_74757_a("C", this.isTallHouse);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
            super.func_143011_b(nbt, manager);
            this.tablePosition = nbt.func_74762_e("T");
            this.isTallHouse = nbt.func_74767_n("C");
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(world, box);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_BLOCK.func_176203_a(1));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_COBBLESTONE_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_LOG.func_176223_P());
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_FENCE.func_176223_P());
            this.func_175804_a(world, box, 1, 1, 1, 3, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_74882_a(world, box, 0, 0, 0, 3, 0, 4, false, rand, villageStones);
            this.func_74882_a(world, box, 1, 0, 1, 2, 0, 3, false, rand, villageDirts);
            if (this.isTallHouse) {
                this.func_74882_a(world, box, 1, 4, 1, 2, 4, 3, false, rand, villageLogs);
            } else {
                this.func_74882_a(world, box, 1, 5, 1, 2, 5, 3, false, rand, villageLogs);
            }
            this.func_175811_a(world, iblockstate3, 1, 4, 0, box);
            this.func_175811_a(world, iblockstate3, 2, 4, 0, box);
            this.func_175811_a(world, iblockstate3, 1, 4, 4, box);
            this.func_175811_a(world, iblockstate3, 2, 4, 4, box);
            this.func_175811_a(world, iblockstate3, 0, 4, 1, box);
            this.func_175811_a(world, iblockstate3, 0, 4, 2, box);
            this.func_175811_a(world, iblockstate3, 0, 4, 3, box);
            this.func_175811_a(world, iblockstate3, 3, 4, 1, box);
            this.func_175811_a(world, iblockstate3, 3, 4, 2, box);
            this.func_175811_a(world, iblockstate3, 3, 4, 3, box);
            this.func_74882_a(world, box, 0, 1, 0, 0, 3, 0, false, rand, villageLogs);
            this.func_74882_a(world, box, 3, 1, 0, 3, 3, 0, false, rand, villageLogs);
            this.func_74882_a(world, box, 0, 1, 4, 0, 3, 4, false, rand, villageLogs);
            this.func_74882_a(world, box, 3, 1, 4, 3, 3, 4, false, rand, villageLogs);
            this.func_74882_a(world, box, 0, 1, 1, 0, 3, 3, false, rand, villagePlanks);
            this.func_74882_a(world, box, 3, 1, 1, 3, 3, 3, false, rand, villagePlanks);
            this.func_74882_a(world, box, 1, 1, 0, 2, 3, 0, false, rand, villagePlanks);
            this.func_74882_a(world, box, 1, 1, 4, 2, 3, 4, false, rand, villagePlanks);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 3, 2, 2, box);
            if (this.tablePosition > 0) {
                this.func_175811_a(world, iblockstate4, this.tablePosition, 1, 3, box);
                this.func_175811_a(world, Blocks.field_150452_aw.func_176223_P(), this.tablePosition, 2, 3, box);
            }
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 1, 1, 0, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 1, 2, 0, box);
            this.createVillageDoor(world, box, rand, 1, 1, 0);
            if (this.func_175807_a(world, 1, 0, -1, box).func_185904_a() == Material.field_151579_a && this.func_175807_a(world, 1, -1, -1, box).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(world, iblockstate2, 1, 0, -1, box);
                if (this.func_175807_a(world, 1, -1, -1, box).func_177230_c() == NibiruBlocks.NIBIRU_GRASS_PATH) {
                    this.func_175811_a(world, NibiruBlocks.INFECTED_GRASS.func_176223_P(), 1, -1, -1, box);
                }
            }
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.func_74871_b(world, j, 6, i, box);
                    this.func_175808_b(world, iblockstate, j, -1, i, box);
                }
            }
            this.spawnVillagers(world, box, 1, 1, 2, 1);
            return true;
        }
    }

    public static class Well
    extends Village {
        public Well() {
        }

        public Well(Start start, int type, Random rand, int x, int z) {
            super(start, type);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
            this.field_74887_e = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? new StructureBoundingBox(x, 64, z, x + 6 - 1, 78, z + 6 - 1) : new StructureBoundingBox(x, 64, z, x + 6 - 1, 78, z + 6 - 1);
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> list, Random rand) {
            this.generateAndAddRoadPiece((Start)component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, this.func_74877_c());
            this.generateAndAddRoadPiece((Start)component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, this.func_74877_c());
            this.generateAndAddRoadPiece((Start)component, list, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            this.generateAndAddRoadPiece((Start)component, list, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(world, box);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 3, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_BLOCK.func_176203_a(1));
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_FENCE.func_176223_P());
            this.func_175804_a(world, box, 1, 0, 1, 4, 12, 4, iblockstate, NibiruBlocks.INFECTED_WATER_FLUID_BLOCK.func_176223_P(), false);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 2, 12, 2, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 3, 12, 2, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 2, 12, 3, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 3, 12, 3, box);
            this.func_175811_a(world, iblockstate1, 1, 13, 1, box);
            this.func_175811_a(world, iblockstate1, 1, 14, 1, box);
            this.func_175811_a(world, iblockstate1, 4, 13, 1, box);
            this.func_175811_a(world, iblockstate1, 4, 14, 1, box);
            this.func_175811_a(world, iblockstate1, 1, 13, 4, box);
            this.func_175811_a(world, iblockstate1, 1, 14, 4, box);
            this.func_175811_a(world, iblockstate1, 4, 13, 4, box);
            this.func_175811_a(world, iblockstate1, 4, 14, 4, box);
            this.func_74882_a(world, box, 1, 15, 1, 4, 15, 4, false, rand, villageStones);
            for (int i = 0; i <= 5; ++i) {
                for (int j = 0; j <= 5; ++j) {
                    if (j != 0 && j != 5 && i != 0 && i != 5) continue;
                    this.func_175811_a(world, NibiruBlocks.NIBIRU_BLOCK.func_176203_a(1), j, 11, i, box);
                    this.func_74871_b(world, j, 12, i, box);
                }
            }
            return true;
        }
    }

    public static abstract class Village
    extends StructureComponent {
        protected int averageGroundLvl = -1;
        private int villagersSpawned;
        protected int structureType;
        protected Start startPiece;

        public Village() {
        }

        protected Village(Start start, int type) {
            super(type);
            if (start != null) {
                this.structureType = start.structureType;
                this.startPiece = start;
            }
        }

        protected void func_143012_a(NBTTagCompound nbt) {
            nbt.func_74768_a("HPos", this.averageGroundLvl);
            nbt.func_74768_a("VCount", this.villagersSpawned);
            nbt.func_74774_a("Type", (byte)this.structureType);
        }

        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
            this.averageGroundLvl = nbt.func_74762_e("HPos");
            this.villagersSpawned = nbt.func_74762_e("VCount");
            this.structureType = nbt.func_74771_c("Type");
        }

        protected void func_175811_a(World world, IBlockState state, int x, int y, int z, StructureBoundingBox box) {
            IBlockState iblockstate = this.getBiomeSpecificBlockState(state);
            super.func_175811_a(world, iblockstate, x, y, z, box);
        }

        protected void func_175804_a(World world, StructureBoundingBox box, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, IBlockState boundaryBlockState, IBlockState insideBlockState, boolean existingOnly) {
            IBlockState iblockstate = this.getBiomeSpecificBlockState(boundaryBlockState);
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(insideBlockState);
            super.func_175804_a(world, box, xMin, yMin, zMin, xMax, yMax, zMax, iblockstate, iblockstate1, existingOnly);
        }

        protected void func_175808_b(World world, IBlockState state, int x, int y, int z, StructureBoundingBox box) {
            IBlockState iblockstate = this.getBiomeSpecificBlockState(state);
            super.func_175808_b(world, iblockstate, x, y, z, box);
        }

        protected boolean func_186167_a(World world, StructureBoundingBox box, Random rand, int x, int y, int z, ResourceLocation loot) {
            BlockChestMP chest;
            BlockPos pos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            BlockChestMP blockChestMP = chest = this.structureType == 2 ? NibiruBlocks.ALIEN_BERRY_CHEST : NibiruBlocks.INFECTED_CHEST;
            if (box.func_175898_b((Vec3i)pos) && world.func_180495_p(pos).func_177230_c() != chest) {
                IBlockState iblockstate = chest.func_176223_P();
                world.func_180501_a(pos, chest.correctFacing(world, pos, iblockstate), 2);
                TileEntity tileentity = world.func_175625_s(pos);
                if (tileentity instanceof TileEntityChestMP) {
                    ((TileEntityChestMP)tileentity).func_189404_a(loot, rand.nextLong());
                }
                return true;
            }
            return false;
        }

        protected StructureComponent getNextComponentNN(Start start, List<StructureComponent> component, Random rand, int x, int z) {
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        return this.generateAndAddComponent(start, component, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + x, this.field_74887_e.field_78896_c + z, EnumFacing.WEST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return this.generateAndAddComponent(start, component, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + x, this.field_74887_e.field_78896_c + z, EnumFacing.WEST, this.func_74877_c());
                    }
                    case WEST: {
                        return this.generateAndAddComponent(start, component, rand, this.field_74887_e.field_78897_a + z, this.field_74887_e.field_78895_b + x, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                    case EAST: 
                }
                return this.generateAndAddComponent(start, component, rand, this.field_74887_e.field_78897_a + z, this.field_74887_e.field_78895_b + x, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            }
            return null;
        }

        protected StructureComponent getNextComponentPP(Start start, List<StructureComponent> component, Random rand, int x, int z) {
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        return this.generateAndAddComponent(start, component, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + x, this.field_74887_e.field_78896_c + z, EnumFacing.EAST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return this.generateAndAddComponent(start, component, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + x, this.field_74887_e.field_78896_c + z, EnumFacing.EAST, this.func_74877_c());
                    }
                    case WEST: {
                        return this.generateAndAddComponent(start, component, rand, this.field_74887_e.field_78897_a + z, this.field_74887_e.field_78895_b + x, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                    case EAST: 
                }
                return this.generateAndAddComponent(start, component, rand, this.field_74887_e.field_78897_a + z, this.field_74887_e.field_78895_b + x, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            }
            return null;
        }

        protected int getAverageGroundLevel(World world, StructureBoundingBox box) {
            int i = 0;
            int j = 0;
            BlockPos.MutableBlockPos mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
                for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                    mutableblockpos.func_181079_c(l, 64, k);
                    if (!box.func_175898_b((Vec3i)mutableblockpos)) continue;
                    i += Math.max(world.func_175672_r((BlockPos)mutableblockpos).func_177956_o(), world.field_73011_w.func_76557_i() - 1);
                    ++j;
                }
            }
            if (j == 0) {
                return -1;
            }
            return i / j;
        }

        protected boolean canVillageGoDeeper(StructureBoundingBox box) {
            return box != null && box.field_78895_b > 10;
        }

        protected void spawnVillagers(World world, StructureBoundingBox box, int x, int y, int z, int count) {
            if (this.villagersSpawned < count) {
                int l;
                int k;
                int j;
                for (int i = this.villagersSpawned; i < count && box.func_175898_b((Vec3i)new BlockPos(j = this.func_74865_a(x + i, z), k = this.func_74862_a(y), l = this.func_74873_b(x + i, z))); ++i) {
                    ++this.villagersSpawned;
                    EntityNibiruVillager villager = new EntityNibiruVillager(world);
                    villager.func_70012_b((double)j + 0.5, k, (double)l + 0.5, 0.0f, 0.0f);
                    villager.func_180482_a(world.func_175649_E(new BlockPos((Entity)villager)), null);
                    villager.setProfession(this.chooseProfession(i, villager.getProfession()));
                    world.func_72838_d((Entity)villager);
                }
            }
        }

        protected int chooseProfession(int villagersSpawned, int currentVillagerProfession) {
            return currentVillagerProfession;
        }

        protected IBlockState getBiomeSpecificBlockState(IBlockState state) {
            if (this.structureType == 1) {
                if (state.func_177230_c() == NibiruBlocks.NIBIRU_LOG) {
                    return NibiruBlocks.NIBIRU_SANDSTONE.func_176223_P();
                }
                if (state == NibiruBlocks.NIBIRU_BLOCK.func_176203_a(1)) {
                    return NibiruBlocks.NIBIRU_SANDSTONE.func_176223_P();
                }
                if (state == NibiruBlocks.NIBIRU_BLOCK.func_176203_a(2)) {
                    return NibiruBlocks.NIBIRU_SANDSTONE.func_176203_a(1);
                }
                if (state.func_177230_c() == NibiruBlocks.NIBIRU_PLANKS) {
                    return NibiruBlocks.NIBIRU_SANDSTONE.func_176203_a(2);
                }
                if (state.func_177230_c() == NibiruBlocks.INFECTED_OAK_STAIRS) {
                    return NibiruBlocks.NIBIRU_SANDSTONE_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, state.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (state.func_177230_c() == NibiruBlocks.NIBIRU_COBBLESTONE_STAIRS) {
                    return NibiruBlocks.NIBIRU_SANDSTONE_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, state.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (state.func_177230_c() == NibiruBlocks.INFECTED_GRAVEL) {
                    return NibiruBlocks.NIBIRU_SANDSTONE.func_176223_P();
                }
            } else if (this.structureType == 2) {
                if (state.func_177230_c() == NibiruBlocks.NIBIRU_BLOCK) {
                    return NibiruBlocks.TERRASTONE.func_176223_P();
                }
                if (state.func_177230_c() == NibiruBlocks.NIBIRU_GRASS_PATH) {
                    return NibiruBlocks.NIBIRU_GRASS_PATH.func_176203_a(1);
                }
                if (state.func_177230_c() == NibiruBlocks.INFECTED_VINES) {
                    return Blocks.field_150350_a.func_176223_P();
                }
                if (state.func_177230_c() == NibiruBlocks.NIBIRU_LOG) {
                    return NibiruBlocks.NIBIRU_LOG.func_176203_a(3);
                }
                if (state.func_177230_c() == NibiruBlocks.NIBIRU_FENCE) {
                    return NibiruBlocks.NIBIRU_FENCE.func_176203_a(2);
                }
                if (state.func_177230_c() == NibiruBlocks.NIBIRU_PLANKS) {
                    return NibiruBlocks.NIBIRU_PLANKS.func_176203_a(2);
                }
                if (state.func_177230_c() == NibiruBlocks.NIBIRU_BOOKSHELF) {
                    return NibiruBlocks.NIBIRU_BOOKSHELF.func_176203_a(1);
                }
                if (state.func_177230_c() == NibiruBlocks.NIBIRU_CRAFTING_TABLE) {
                    return NibiruBlocks.NIBIRU_CRAFTING_TABLE.func_176203_a(1);
                }
                if (state.func_177230_c() == NibiruBlocks.INFECTED_OAK_STAIRS) {
                    return NibiruBlocks.ALIEN_BERRY_OAK_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, state.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (state.func_177230_c() == NibiruBlocks.NIBIRU_COBBLESTONE_STAIRS) {
                    return NibiruBlocks.TERRASTONE_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, state.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (state.func_177230_c() == NibiruBlocks.INFECTED_WATER_FLUID_BLOCK) {
                    return NibiruBlocks.PURIFY_WATER_FLUID_BLOCK.func_176223_P();
                }
                if (state.func_177230_c() == NibiruBlocks.INFECTED_GRAVEL) {
                    return NibiruBlocks.PURIFY_GRAVEL.func_176223_P();
                }
                if (state.func_177230_c() == NibiruBlocks.INFECTED_PRISMARINE) {
                    return NibiruBlocks.TERRASTONE.func_176223_P();
                }
                if (state.func_177230_c() == NibiruBlocks.INFECTED_VINES_DIRT) {
                    return NibiruBlocks.TERRASTONE.func_176223_P();
                }
                if (state.func_177230_c() == NibiruBlocks.HALF_INFECTED_STONE_BRICKS_SLAB) {
                    return NibiruBlocks.HALF_INFECTED_STONE_BRICKS_SLAB.func_176223_P().func_177226_a(BlockHalfInfectedStoneBricksSlab.VARIANT, (Comparable)((Object)BlockHalfInfectedStoneBricksSlab.BlockType.TERRASTONE_SLAB));
                }
                if (state.func_177230_c() == NibiruBlocks.DOUBLE_INFECTED_STONE_BRICKS_SLAB) {
                    return NibiruBlocks.DOUBLE_INFECTED_STONE_BRICKS_SLAB.func_176223_P().func_177226_a(BlockHalfInfectedStoneBricksSlab.VARIANT, (Comparable)((Object)BlockHalfInfectedStoneBricksSlab.BlockType.TERRASTONE_SLAB));
                }
                if (state.func_177230_c() == NibiruBlocks.NIBIRU_FURNACE) {
                    return NibiruBlocks.TERRASTONE_FURNACE.func_176223_P();
                }
            }
            return state;
        }

        protected BlockDoor getDoor() {
            switch (this.structureType) {
                case 2: {
                    return NibiruBlocks.ALIEN_BERRY_OAK_DOOR_BLOCK;
                }
            }
            return NibiruBlocks.INFECTED_DOOR_BLOCK;
        }

        protected void createVillageDoor(World world, StructureBoundingBox box, Random rand, int x, int y, int z) {
            this.func_189915_a(world, box, rand, x, y, z, EnumFacing.NORTH, this.getDoor());
        }

        protected void placeTorch(World world, EnumFacing facing, int x, int y, int z, StructureBoundingBox box) {
            Block torch = this.structureType == 2 ? GCBlocks.glowstoneTorch : NibiruBlocks.INFECTED_TORCH;
            this.func_175811_a(world, torch.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing), x, y, z, box);
        }

        protected void setVillageType(int type) {
            this.structureType = type;
        }

        private int updatePieceWeight(List<PieceWeight> list) {
            boolean flag = false;
            int i = 0;
            for (PieceWeight piece : list) {
                if (piece.villagePiecesLimit > 0 && piece.villagePiecesSpawned < piece.villagePiecesLimit) {
                    flag = true;
                }
                i += piece.villagePieceWeight;
            }
            return flag ? i : -1;
        }

        private Village findAndCreateComponentFactory(Start start, PieceWeight weight, List<StructureComponent> component, Random rand, int x, int y, int z, EnumFacing facing, int type) {
            Class<? extends Village> oclass = weight.villagePieceClass;
            Village village = null;
            if (oclass == House4Garden.class) {
                village = this.createHouse4GardenPiece(start, component, rand, x, y, z, facing, type);
            } else if (oclass == Church.class) {
                village = this.createChurchPiece(start, component, x, y, z, facing, type);
            } else if (oclass == House1.class) {
                village = this.createHouse1Piece(start, component, x, y, z, facing, type);
            } else if (oclass == WoodHut.class) {
                village = this.createWoodHutPiece(start, component, rand, x, y, z, facing, type);
            } else if (oclass == Hall.class) {
                village = this.createHallPiece(start, component, x, y, z, facing, type);
            } else if (oclass == Field1.class) {
                village = this.createField1Piece(start, component, rand, x, y, z, facing, type);
            } else if (oclass == Field2.class) {
                village = this.createField2Piece(start, component, rand, x, y, z, facing, type);
            } else if (oclass == House2.class) {
                village = this.createHouse2Piece(start, component, x, y, z, facing, type);
            } else if (oclass == House3.class) {
                village = this.createHouse3Piece(start, component, x, y, z, facing, type);
            }
            return village;
        }

        private Village generateComponent(Start start, List<StructureComponent> component, Random rand, int x, int y, int z, EnumFacing facing, int type) {
            int i = this.updatePieceWeight(start.structureVillageWeightedPieceList);
            if (i <= 0) {
                return null;
            }
            int j = 0;
            block0: while (j < 5) {
                ++j;
                int k = rand.nextInt(i);
                for (PieceWeight piece : start.structureVillageWeightedPieceList) {
                    if ((k -= piece.villagePieceWeight) >= 0) continue;
                    if (!piece.canSpawnMoreVillagePiecesOfType(type) || piece == start.structVillagePieceWeight && start.structureVillageWeightedPieceList.size() > 1) continue block0;
                    Village village = this.findAndCreateComponentFactory(start, piece, component, rand, x, y, z, facing, type);
                    if (village == null) continue;
                    ++piece.villagePiecesSpawned;
                    start.structVillagePieceWeight = piece;
                    if (!piece.canSpawnMoreVillagePieces()) {
                        start.structureVillageWeightedPieceList.remove(piece);
                    }
                    return village;
                }
            }
            StructureBoundingBox box = Torch.findPieceBox(start, component, x, y, z, facing);
            if (box != null) {
                return new Torch(start, type, box, facing);
            }
            return null;
        }

        private StructureComponent generateAndAddComponent(Start start, List<StructureComponent> component, Random rand, int x, int y, int z, EnumFacing facing, int type) {
            if (type > 50) {
                return null;
            }
            if (Math.abs(x - start.func_74874_b().field_78897_a) <= 112 && Math.abs(z - start.func_74874_b().field_78896_c) <= 112) {
                Village structurecomponent = this.generateComponent(start, component, rand, x, y, z, facing, type + 1);
                if (structurecomponent != null) {
                    component.add(structurecomponent);
                    start.pendingHouses.add(structurecomponent);
                    return structurecomponent;
                }
                return null;
            }
            return null;
        }

        protected StructureComponent generateAndAddRoadPiece(Start start, List<StructureComponent> list, Random rand, int x, int y, int z, EnumFacing facing, int type) {
            if (type > 3 + start.terrainType) {
                return null;
            }
            if (Math.abs(x - start.func_74874_b().field_78897_a) <= 112 && Math.abs(z - start.func_74874_b().field_78896_c) <= 112) {
                StructureBoundingBox box = Path.findPieceBox(start, list, rand, x, y, z, facing);
                if (box != null && box.field_78895_b > 10) {
                    Path component = new Path(start, type, box, facing);
                    list.add(component);
                    start.pendingRoads.add(component);
                    return component;
                }
                return null;
            }
            return null;
        }

        private House4Garden createHouse4GardenPiece(Start start, List<StructureComponent> list, Random rand, int x, int y, int z, EnumFacing facing, int type) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)5, (int)6, (int)5, (EnumFacing)facing);
            return StructureComponent.func_74883_a(list, (StructureBoundingBox)box) != null ? null : new House4Garden(start, type, rand, box, facing);
        }

        private Church createChurchPiece(Start start, List<StructureComponent> list, int x, int y, int z, EnumFacing facing, int type) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)5, (int)12, (int)9, (EnumFacing)facing);
            return this.canVillageGoDeeper(box) && StructureComponent.func_74883_a(list, (StructureBoundingBox)box) == null ? new Church(start, type, box, facing) : null;
        }

        private House1 createHouse1Piece(Start start, List<StructureComponent> list, int x, int y, int z, EnumFacing facing, int type) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)9, (int)9, (int)6, (EnumFacing)facing);
            return this.canVillageGoDeeper(box) && StructureComponent.func_74883_a(list, (StructureBoundingBox)box) == null ? new House1(start, type, box, facing) : null;
        }

        private WoodHut createWoodHutPiece(Start start, List<StructureComponent> list, Random rand, int x, int y, int z, EnumFacing facing, int type) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)4, (int)6, (int)5, (EnumFacing)facing);
            return this.canVillageGoDeeper(box) && StructureComponent.func_74883_a(list, (StructureBoundingBox)box) == null ? new WoodHut(start, type, rand, box, facing) : null;
        }

        private Hall createHallPiece(Start start, List<StructureComponent> list, int x, int y, int z, EnumFacing facing, int type) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)9, (int)7, (int)11, (EnumFacing)facing);
            return this.canVillageGoDeeper(box) && StructureComponent.func_74883_a(list, (StructureBoundingBox)box) == null ? new Hall(start, type, box, facing) : null;
        }

        private Field1 createField1Piece(Start start, List<StructureComponent> list, Random rand, int x, int y, int z, EnumFacing facing, int type) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)13, (int)4, (int)9, (EnumFacing)facing);
            return this.canVillageGoDeeper(box) && StructureComponent.func_74883_a(list, (StructureBoundingBox)box) == null ? new Field1(start, type, rand, box, facing) : null;
        }

        private Field2 createField2Piece(Start start, List<StructureComponent> list, Random rand, int x, int y, int z, EnumFacing facing, int type) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)7, (int)4, (int)9, (EnumFacing)facing);
            return this.canVillageGoDeeper(box) && StructureComponent.func_74883_a(list, (StructureBoundingBox)box) == null ? new Field2(start, type, rand, box, facing) : null;
        }

        private House2 createHouse2Piece(Start start, List<StructureComponent> list, int x, int y, int z, EnumFacing facing, int type) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)10, (int)6, (int)7, (EnumFacing)facing);
            return this.canVillageGoDeeper(box) && StructureComponent.func_74883_a(list, (StructureBoundingBox)box) == null ? new House2(start, type, box, facing) : null;
        }

        private House3 createHouse3Piece(Start start, List<StructureComponent> list, int x, int y, int z, EnumFacing facing, int type) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)9, (int)7, (int)12, (EnumFacing)facing);
            return this.canVillageGoDeeper(box) && StructureComponent.func_74883_a(list, (StructureBoundingBox)box) == null ? new House3(start, type, box, facing) : null;
        }
    }

    public static class Torch
    extends Village {
        public Torch() {
        }

        public Torch(Start start, int type, StructureBoundingBox box, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = box;
        }

        public static StructureBoundingBox findPieceBox(Start start, List<StructureComponent> list, int x, int y, int z, EnumFacing facing) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)3, (int)4, (int)2, (EnumFacing)facing);
            return StructureComponent.func_74883_a(list, (StructureBoundingBox)box) != null ? null : box;
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(world, box);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_FENCE.func_176223_P());
            this.func_175804_a(world, box, 0, 0, 0, 2, 3, 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(world, iblockstate, 1, 0, 0, box);
            this.func_175811_a(world, iblockstate, 1, 1, 0, box);
            this.func_175811_a(world, iblockstate, 1, 2, 0, box);
            this.func_175811_a(world, NibiruBlocks.INFECTED_PRISMARINE.func_176203_a(2), 1, 3, 0, box);
            this.placeTorch(world, EnumFacing.EAST, 2, 3, 0, box);
            this.placeTorch(world, EnumFacing.NORTH, 1, 3, 1, box);
            this.placeTorch(world, EnumFacing.WEST, 0, 3, 0, box);
            this.placeTorch(world, EnumFacing.SOUTH, 1, 3, -1, box);
            return true;
        }
    }

    public static class Start
    extends Well {
        public BiomeProvider biomeProvider;
        public int terrainType;
        public PieceWeight structVillagePieceWeight;
        public List<PieceWeight> structureVillageWeightedPieceList;
        public List<StructureComponent> pendingHouses = new ArrayList<StructureComponent>();
        public List<StructureComponent> pendingRoads = new ArrayList<StructureComponent>();
        public Biome biome;

        public Start() {
        }

        public Start(BiomeProvider biomeProvider, Random rand, int x, int z, List<PieceWeight> list, int type) {
            super(null, 0, rand, x, z);
            Biome biome;
            this.biomeProvider = biomeProvider;
            this.structureVillageWeightedPieceList = list;
            this.terrainType = type;
            this.biome = biome = biomeProvider.func_180300_a(new BlockPos(x, 0, z), Biomes.field_180279_ad);
            this.startPiece = this;
            if (biome == MPBiomes.INFECTED_DESERT) {
                this.structureType = 1;
            } else if (biome == MPBiomes.GREEN_VEIN) {
                this.structureType = 2;
            }
            this.setVillageType(this.structureType);
        }
    }

    public static abstract class Road
    extends Village {
        public Road() {
        }

        protected Road(Start start, int type) {
            super(start, type);
        }
    }

    public static class PieceWeight {
        public Class<? extends Village> villagePieceClass;
        public final int villagePieceWeight;
        public int villagePiecesSpawned;
        public int villagePiecesLimit;

        public PieceWeight(Class<? extends Village> clazz, int weight, int limit) {
            this.villagePieceClass = clazz;
            this.villagePieceWeight = weight;
            this.villagePiecesLimit = limit;
        }

        public boolean canSpawnMoreVillagePiecesOfType(int type) {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }

        public boolean canSpawnMoreVillagePieces() {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }
    }

    public static class Path
    extends Road {
        private int length;

        public Path() {
        }

        public Path(Start start, int type, StructureBoundingBox box, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = box;
            this.length = Math.max(box.func_78883_b(), box.func_78880_d());
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74768_a("Length", this.length);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
            super.func_143011_b(nbt, manager);
            this.length = nbt.func_74762_e("Length");
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> list, Random rand) {
            boolean flag = false;
            for (int i = rand.nextInt(5); i < this.length - 8; i += 2 + rand.nextInt(5)) {
                StructureComponent structurecomponent = this.getNextComponentNN((Start)component, list, rand, 0, i);
                if (structurecomponent == null) continue;
                i += Math.max(structurecomponent.func_74874_b().func_78883_b(), structurecomponent.func_74874_b().func_78880_d());
                flag = true;
            }
            for (int j = rand.nextInt(5); j < this.length - 8; j += 2 + rand.nextInt(5)) {
                StructureComponent structurecomponent1 = this.getNextComponentPP((Start)component, list, rand, 0, j);
                if (structurecomponent1 == null) continue;
                j += Math.max(structurecomponent1.func_74874_b().func_78883_b(), structurecomponent1.func_74874_b().func_78880_d());
                flag = true;
            }
            EnumFacing enumfacing = this.func_186165_e();
            if (flag && rand.nextInt(3) > 0 && enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        this.generateAndAddRoadPiece((Start)component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.WEST, this.func_74877_c());
                        break;
                    }
                    case SOUTH: {
                        this.generateAndAddRoadPiece((Start)component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, EnumFacing.WEST, this.func_74877_c());
                        break;
                    }
                    case WEST: {
                        this.generateAndAddRoadPiece((Start)component, list, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                        break;
                    }
                    case EAST: {
                        this.generateAndAddRoadPiece((Start)component, list, rand, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                }
            }
            if (flag && rand.nextInt(3) > 0 && enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        this.generateAndAddRoadPiece((Start)component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.EAST, this.func_74877_c());
                        break;
                    }
                    case SOUTH: {
                        this.generateAndAddRoadPiece((Start)component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, EnumFacing.EAST, this.func_74877_c());
                        break;
                    }
                    case WEST: {
                        this.generateAndAddRoadPiece((Start)component, list, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                        break;
                    }
                    case EAST: {
                        this.generateAndAddRoadPiece((Start)component, list, rand, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                }
            }
        }

        public static StructureBoundingBox findPieceBox(Start start, List<StructureComponent> list, Random rand, int x, int y, int z, EnumFacing facing) {
            for (int i = 7 * MathHelper.func_76136_a((Random)rand, (int)3, (int)5); i >= 7; i -= 7) {
                StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)3, (int)3, (int)i, (EnumFacing)facing);
                if (StructureComponent.func_74883_a(list, (StructureBoundingBox)box) != null) continue;
                return box;
            }
            return null;
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            IBlockState iblockstate = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_GRASS_PATH.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_PLANKS.func_176223_P());
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                block1: for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    BlockPos blockpos = new BlockPos(i, 64, j);
                    if (!box.func_175898_b((Vec3i)blockpos)) continue;
                    if ((blockpos = world.func_175672_r(blockpos).func_177977_b()).func_177956_o() < world.func_181545_F()) {
                        blockpos = new BlockPos(blockpos.func_177958_n(), world.func_181545_F() - 1, blockpos.func_177952_p());
                    }
                    while (blockpos.func_177956_o() >= world.func_181545_F() - 1) {
                        IBlockState iblockstate4 = world.func_180495_p(blockpos);
                        if (iblockstate4.func_177230_c() == NibiruBlocks.INFECTED_GRASS && world.func_175623_d(blockpos.func_177984_a())) {
                            world.func_180501_a(blockpos, iblockstate, 2);
                            continue block1;
                        }
                        if (iblockstate4.func_185904_a().func_76224_d()) {
                            world.func_180501_a(blockpos, iblockstate1, 2);
                            continue block1;
                        }
                        blockpos = blockpos.func_177977_b();
                    }
                }
            }
            return true;
        }
    }

    public static class House4Garden
    extends Village {
        private boolean isRoofAccessible;

        public House4Garden() {
        }

        public House4Garden(Start start, int type, Random rand, StructureBoundingBox box, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = box;
            this.isRoofAccessible = rand.nextBoolean();
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("Terrace", this.isRoofAccessible);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
            super.func_143011_b(nbt, manager);
            this.isRoofAccessible = nbt.func_74767_n("Terrace");
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(world, box);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_BLOCK.func_176203_a(1));
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_PLANKS.func_176223_P());
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_COBBLESTONE_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_FENCE.func_176223_P());
            this.func_74882_a(world, box, 0, 0, 0, 4, 0, 4, false, rand, villageStones);
            this.func_74882_a(world, box, 0, 4, 0, 4, 4, 4, false, rand, villageLogs);
            this.func_74882_a(world, box, 1, 4, 1, 3, 4, 3, false, rand, villagePlanks);
            this.func_175811_a(world, iblockstate, 0, 1, 0, box);
            this.func_175811_a(world, iblockstate, 0, 2, 0, box);
            this.func_175811_a(world, iblockstate, 0, 3, 0, box);
            this.func_175811_a(world, iblockstate, 4, 1, 0, box);
            this.func_175811_a(world, iblockstate, 4, 2, 0, box);
            this.func_175811_a(world, iblockstate, 4, 3, 0, box);
            this.func_175811_a(world, iblockstate, 0, 1, 4, box);
            this.func_175811_a(world, iblockstate, 0, 2, 4, box);
            this.func_175811_a(world, iblockstate, 0, 3, 4, box);
            this.func_175811_a(world, iblockstate, 4, 1, 4, box);
            this.func_175811_a(world, iblockstate, 4, 2, 4, box);
            this.func_175811_a(world, iblockstate, 4, 3, 4, box);
            this.func_74882_a(world, box, 0, 1, 1, 0, 3, 3, false, rand, villagePlanks);
            this.func_74882_a(world, box, 4, 1, 1, 4, 3, 3, false, rand, villagePlanks);
            this.func_74882_a(world, box, 1, 1, 4, 3, 3, 4, false, rand, villagePlanks);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 2, 2, 4, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 4, 2, 2, box);
            this.func_175811_a(world, iblockstate1, 1, 1, 0, box);
            this.func_175811_a(world, iblockstate1, 1, 2, 0, box);
            this.func_175811_a(world, iblockstate1, 1, 3, 0, box);
            this.func_175811_a(world, iblockstate1, 2, 3, 0, box);
            this.func_175811_a(world, iblockstate1, 3, 3, 0, box);
            this.func_175811_a(world, iblockstate1, 3, 2, 0, box);
            this.func_175811_a(world, iblockstate1, 3, 1, 0, box);
            if (this.func_175807_a(world, 2, 0, -1, box).func_185904_a() == Material.field_151579_a && this.func_175807_a(world, 2, -1, -1, box).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(world, iblockstate2, 2, 0, -1, box);
                if (this.func_175807_a(world, 2, -1, -1, box).func_177230_c() == NibiruBlocks.NIBIRU_GRASS_PATH) {
                    this.func_175811_a(world, NibiruBlocks.INFECTED_GRASS.func_176223_P(), 2, -1, -1, box);
                }
            }
            this.func_175804_a(world, box, 1, 1, 1, 3, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            if (this.isRoofAccessible) {
                this.func_175811_a(world, iblockstate4, 0, 5, 0, box);
                this.func_175811_a(world, iblockstate4, 1, 5, 0, box);
                this.func_175811_a(world, iblockstate4, 2, 5, 0, box);
                this.func_175811_a(world, iblockstate4, 3, 5, 0, box);
                this.func_175811_a(world, iblockstate4, 4, 5, 0, box);
                this.func_175811_a(world, iblockstate4, 0, 5, 4, box);
                this.func_175811_a(world, iblockstate4, 1, 5, 4, box);
                this.func_175811_a(world, iblockstate4, 2, 5, 4, box);
                this.func_175811_a(world, iblockstate4, 3, 5, 4, box);
                this.func_175811_a(world, iblockstate4, 4, 5, 4, box);
                this.func_175811_a(world, iblockstate4, 4, 5, 1, box);
                this.func_175811_a(world, iblockstate4, 4, 5, 2, box);
                this.func_175811_a(world, iblockstate4, 4, 5, 3, box);
                this.func_175811_a(world, iblockstate4, 0, 5, 1, box);
                this.func_175811_a(world, iblockstate4, 0, 5, 2, box);
                this.func_175811_a(world, iblockstate4, 0, 5, 3, box);
            }
            if (this.isRoofAccessible) {
                IBlockState iblockstate5 = Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.SOUTH);
                this.func_175811_a(world, iblockstate5, 3, 1, 3, box);
                this.func_175811_a(world, iblockstate5, 3, 2, 3, box);
                this.func_175811_a(world, iblockstate5, 3, 3, 3, box);
                this.func_175811_a(world, iblockstate5, 3, 4, 3, box);
            }
            this.placeTorch(world, EnumFacing.NORTH, 2, 3, 1, box);
            for (int j = 0; j < 5; ++j) {
                for (int i = 0; i < 5; ++i) {
                    this.func_74871_b(world, i, 6, j, box);
                    this.func_175808_b(world, iblockstate, i, -1, j, box);
                }
            }
            this.spawnVillagers(world, box, 1, 1, 2, 1);
            return true;
        }
    }

    public static class House3
    extends Village {
        public House3() {
        }

        public House3(Start start, int type, StructureBoundingBox box, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = box;
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(world, box);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_BLOCK.func_176203_a(1));
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(NibiruBlocks.INFECTED_OAK_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(NibiruBlocks.INFECTED_OAK_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(NibiruBlocks.INFECTED_OAK_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(NibiruBlocks.INFECTED_OAK_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
            IBlockState iblockstate5 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_PLANKS.func_176223_P());
            IBlockState iblockstate6 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_LOG.func_176223_P());
            this.func_175804_a(world, box, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, box, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_74882_a(world, box, 2, 0, 5, 8, 0, 10, false, rand, villagePlanks);
            this.func_74882_a(world, box, 1, 0, 1, 7, 0, 4, false, rand, villagePlanks);
            this.func_74882_a(world, box, 0, 0, 0, 0, 3, 5, false, rand, villageStones);
            this.func_74882_a(world, box, 8, 0, 0, 8, 3, 10, false, rand, villageStones);
            this.func_74882_a(world, box, 1, 0, 0, 7, 2, 0, false, rand, villageStones);
            this.func_74882_a(world, box, 1, 0, 5, 2, 1, 5, false, rand, villageStones);
            this.func_74882_a(world, box, 2, 0, 6, 2, 3, 10, false, rand, villageStones);
            this.func_74882_a(world, box, 3, 0, 10, 7, 3, 10, false, rand, villageStones);
            this.func_74882_a(world, box, 1, 2, 0, 7, 3, 0, false, rand, villagePlanks);
            this.func_74882_a(world, box, 1, 2, 5, 2, 3, 5, false, rand, villagePlanks);
            this.func_74882_a(world, box, 0, 4, 1, 8, 4, 1, false, rand, villagePlanks);
            this.func_74882_a(world, box, 0, 4, 4, 3, 4, 4, false, rand, villagePlanks);
            this.func_74882_a(world, box, 0, 5, 2, 8, 5, 3, false, rand, villagePlanks);
            this.func_175811_a(world, iblockstate5, 0, 4, 2, box);
            this.func_175811_a(world, iblockstate5, 0, 4, 3, box);
            this.func_175811_a(world, iblockstate5, 8, 4, 2, box);
            this.func_175811_a(world, iblockstate5, 8, 4, 3, box);
            this.func_175811_a(world, iblockstate5, 8, 4, 4, box);
            IBlockState iblockstate7 = iblockstate1;
            IBlockState iblockstate8 = iblockstate2;
            IBlockState iblockstate9 = iblockstate4;
            IBlockState iblockstate10 = iblockstate3;
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.func_175811_a(world, iblockstate7, j, 4 + i, i, box);
                    if (i <= -1 && j > 1 || i <= 0 && j > 3 || i <= 1 && j > 4 && j < 6) continue;
                    this.func_175811_a(world, iblockstate8, j, 4 + i, 5 - i, box);
                }
            }
            this.func_74882_a(world, box, 3, 4, 5, 3, 4, 10, false, rand, villagePlanks);
            this.func_74882_a(world, box, 7, 4, 2, 7, 4, 10, false, rand, villagePlanks);
            this.func_74882_a(world, box, 4, 5, 4, 4, 5, 10, false, rand, villagePlanks);
            this.func_74882_a(world, box, 6, 5, 4, 6, 5, 10, false, rand, villagePlanks);
            this.func_74882_a(world, box, 5, 6, 3, 5, 6, 10, false, rand, villagePlanks);
            for (int k = 4; k >= 1; --k) {
                this.func_175811_a(world, iblockstate5, k, 2 + k, 7 - k, box);
                for (int k1 = 8 - k; k1 <= 10; ++k1) {
                    this.func_175811_a(world, iblockstate10, k, 2 + k, k1, box);
                }
            }
            this.func_175811_a(world, iblockstate5, 6, 6, 3, box);
            this.func_175811_a(world, iblockstate5, 7, 5, 4, box);
            this.func_175811_a(world, iblockstate4, 6, 6, 4, box);
            for (int l = 6; l <= 8; ++l) {
                for (int l1 = 5; l1 <= 10; ++l1) {
                    this.func_175811_a(world, iblockstate9, l, 12 - l, l1, box);
                }
            }
            this.func_175811_a(world, iblockstate6, 0, 2, 1, box);
            this.func_175811_a(world, iblockstate6, 0, 2, 4, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 0, 2, 3, box);
            this.func_175811_a(world, iblockstate6, 4, 2, 0, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 5, 2, 0, box);
            this.func_175811_a(world, iblockstate6, 6, 2, 0, box);
            this.func_175811_a(world, iblockstate6, 8, 2, 1, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 8, 2, 2, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 8, 2, 3, box);
            this.func_175811_a(world, iblockstate6, 8, 2, 4, box);
            this.func_175811_a(world, iblockstate5, 8, 2, 5, box);
            this.func_175811_a(world, iblockstate6, 8, 2, 6, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 8, 2, 7, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 8, 2, 8, box);
            this.func_175811_a(world, iblockstate6, 8, 2, 9, box);
            this.func_175811_a(world, iblockstate6, 2, 2, 6, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 2, 2, 7, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 2, 2, 8, box);
            this.func_175811_a(world, iblockstate6, 2, 2, 9, box);
            this.func_175811_a(world, iblockstate6, 4, 4, 10, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 5, 4, 10, box);
            this.func_175811_a(world, iblockstate6, 6, 4, 10, box);
            this.func_175811_a(world, iblockstate5, 5, 5, 10, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, box);
            this.placeTorch(world, EnumFacing.NORTH, 2, 3, 1, box);
            this.createVillageDoor(world, box, rand, 2, 1, 0);
            this.func_175804_a(world, box, 1, 0, -1, 3, 2, -1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            if (this.func_175807_a(world, 2, 0, -1, box).func_185904_a() == Material.field_151579_a && this.func_175807_a(world, 2, -1, -1, box).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(world, iblockstate7, 2, 0, -1, box);
                if (this.func_175807_a(world, 2, -1, -1, box).func_177230_c() == NibiruBlocks.NIBIRU_GRASS_PATH) {
                    this.func_175811_a(world, NibiruBlocks.INFECTED_GRASS.func_176223_P(), 2, -1, -1, box);
                }
            }
            for (int i1 = 0; i1 < 5; ++i1) {
                for (int i2 = 0; i2 < 9; ++i2) {
                    this.func_74871_b(world, i2, 7, i1, box);
                    this.func_175808_b(world, iblockstate, i2, -1, i1, box);
                }
            }
            for (int j1 = 5; j1 < 11; ++j1) {
                for (int j2 = 2; j2 < 9; ++j2) {
                    this.func_74871_b(world, j2, 7, j1, box);
                    this.func_175808_b(world, iblockstate, j2, -1, j1, box);
                }
            }
            this.spawnVillagers(world, box, 4, 1, 2, 2);
            return true;
        }
    }

    public static class House2
    extends Village {
        private boolean hasMadeChest;

        public House2() {
        }

        public House2(Start start, int type, StructureBoundingBox box, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = box;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("Chest", this.hasMadeChest);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
            super.func_143011_b(nbt, manager);
            this.hasMadeChest = nbt.func_74767_n("Chest");
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(world, box);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            IBlockState iblockstate = NibiruBlocks.NIBIRU_BLOCK.func_176203_a(1);
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(NibiruBlocks.INFECTED_OAK_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(NibiruBlocks.INFECTED_OAK_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_PLANKS.func_176223_P());
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_COBBLESTONE_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate6 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_FENCE.func_176223_P());
            this.func_175804_a(world, box, 0, 1, 0, 9, 4, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_74882_a(world, box, 0, 0, 0, 9, 0, 6, false, rand, villageStones);
            this.func_74882_a(world, box, 0, 4, 0, 9, 4, 6, false, rand, villageStones);
            this.func_175804_a(world, box, 0, 5, 0, 9, 5, 6, NibiruBlocks.HALF_INFECTED_STONE_BRICKS_SLAB.func_176223_P(), NibiruBlocks.HALF_INFECTED_STONE_BRICKS_SLAB.func_176223_P(), false);
            this.func_175804_a(world, box, 1, 5, 1, 8, 5, 5, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_74882_a(world, box, 1, 1, 0, 2, 3, 0, false, rand, villagePlanks);
            this.func_74882_a(world, box, 0, 1, 0, 0, 4, 0, false, rand, villageLogs);
            this.func_74882_a(world, box, 3, 1, 0, 3, 4, 0, false, rand, villageLogs);
            this.func_74882_a(world, box, 0, 1, 6, 0, 4, 6, false, rand, villageLogs);
            this.func_175811_a(world, iblockstate3, 3, 3, 1, box);
            this.func_74882_a(world, box, 3, 1, 2, 3, 3, 2, false, rand, villagePlanks);
            this.func_74882_a(world, box, 4, 1, 3, 5, 3, 3, false, rand, villagePlanks);
            this.func_74882_a(world, box, 0, 1, 1, 0, 3, 5, false, rand, villagePlanks);
            this.func_74882_a(world, box, 1, 1, 6, 5, 3, 6, false, rand, villagePlanks);
            this.func_175804_a(world, box, 5, 1, 0, 5, 3, 0, iblockstate6, iblockstate6, false);
            this.func_175804_a(world, box, 9, 1, 0, 9, 3, 0, iblockstate6, iblockstate6, false);
            this.func_74882_a(world, box, 6, 1, 4, 9, 4, 6, false, rand, villageStones);
            IBlockState lava = rand.nextInt(100) == 0 ? NibiruBlocks.NUCLEAR_WASTE_FLUID_BLOCK.func_176223_P() : Blocks.field_150356_k.func_176223_P();
            this.func_175811_a(world, lava, 7, 1, 5, box);
            this.func_175811_a(world, lava, 8, 1, 5, box);
            this.func_175811_a(world, Blocks.field_150411_aY.func_176223_P(), 9, 2, 5, box);
            this.func_175811_a(world, Blocks.field_150411_aY.func_176223_P(), 9, 2, 4, box);
            this.func_175804_a(world, box, 7, 2, 4, 8, 2, 5, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(world, iblockstate, 6, 1, 3, box);
            this.func_175811_a(world, NibiruBlocks.NIBIRU_FURNACE.func_176223_P(), 6, 2, 3, box);
            this.func_175811_a(world, NibiruBlocks.NIBIRU_FURNACE.func_176223_P(), 6, 3, 3, box);
            this.func_175811_a(world, NibiruBlocks.DOUBLE_INFECTED_STONE_BRICKS_SLAB.func_176223_P(), 8, 1, 1, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 0, 2, 4, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 2, 2, 6, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 4, 2, 6, box);
            this.func_175811_a(world, iblockstate6, 2, 1, 4, box);
            this.func_175811_a(world, Blocks.field_150452_aw.func_176223_P(), 2, 2, 4, box);
            this.func_175811_a(world, iblockstate3, 1, 1, 5, box);
            this.func_175811_a(world, iblockstate1, 2, 1, 5, box);
            this.func_175811_a(world, iblockstate2, 1, 1, 4, box);
            if (!this.hasMadeChest && box.func_175898_b((Vec3i)new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(1), this.func_74873_b(5, 5)))) {
                this.hasMadeChest = true;
                this.func_186167_a(world, box, rand, 5, 1, 5, MPLootTables.NIBIRU_VILLAGE_BLACKSMITH);
            }
            for (int i = 6; i <= 8; ++i) {
                if (this.func_175807_a(world, i, 0, -1, box).func_185904_a() != Material.field_151579_a || this.func_175807_a(world, i, -1, -1, box).func_185904_a() == Material.field_151579_a) continue;
                this.func_175811_a(world, iblockstate4, i, 0, -1, box);
                if (this.func_175807_a(world, i, -1, -1, box).func_177230_c() != NibiruBlocks.NIBIRU_GRASS_PATH) continue;
                this.func_175811_a(world, NibiruBlocks.INFECTED_GRASS.func_176223_P(), i, -1, -1, box);
            }
            for (int k = 0; k < 7; ++k) {
                for (int j = 0; j < 10; ++j) {
                    this.func_74871_b(world, j, 6, k, box);
                    this.func_175808_b(world, iblockstate, j, -1, k, box);
                }
            }
            this.spawnVillagers(world, box, 7, 1, 1, 1);
            return true;
        }

        @Override
        protected int chooseProfession(int villagersSpawned, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class House1
    extends Village {
        public House1() {
        }

        public House1(Start start, int type, StructureBoundingBox box, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = box;
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(world, box);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 9 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_BLOCK.func_176203_a(1));
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(NibiruBlocks.INFECTED_OAK_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(NibiruBlocks.INFECTED_OAK_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(NibiruBlocks.INFECTED_OAK_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_PLANKS.func_176223_P());
            IBlockState iblockstate5 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_COBBLESTONE_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate6 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_FENCE.func_176223_P());
            this.func_175804_a(world, box, 1, 1, 1, 7, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_74882_a(world, box, 0, 0, 0, 8, 0, 5, false, rand, villageStones);
            this.func_74882_a(world, box, 0, 5, 0, 8, 5, 5, false, rand, villageStones);
            this.func_74882_a(world, box, 0, 6, 1, 8, 6, 4, false, rand, villageStones);
            this.func_74882_a(world, box, 0, 7, 2, 8, 7, 3, false, rand, villageStones);
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.func_175811_a(world, iblockstate1, j, 6 + i, i, box);
                    this.func_175811_a(world, iblockstate2, j, 6 + i, 5 - i, box);
                }
            }
            this.func_74882_a(world, box, 0, 1, 0, 0, 1, 5, false, rand, villageStones);
            this.func_74882_a(world, box, 1, 1, 5, 8, 1, 5, false, rand, villageStones);
            this.func_74882_a(world, box, 8, 1, 0, 8, 1, 4, false, rand, villageStones);
            this.func_74882_a(world, box, 2, 1, 0, 7, 1, 0, false, rand, villageStones);
            this.func_74882_a(world, box, 0, 2, 0, 0, 4, 0, false, rand, villageStones);
            this.func_74882_a(world, box, 0, 2, 5, 0, 4, 5, false, rand, villageStones);
            this.func_74882_a(world, box, 8, 2, 5, 8, 4, 5, false, rand, villageStones);
            this.func_74882_a(world, box, 8, 2, 0, 8, 4, 0, false, rand, villageStones);
            this.func_74882_a(world, box, 0, 2, 1, 0, 4, 4, false, rand, villagePlanks);
            this.func_74882_a(world, box, 1, 2, 5, 7, 4, 5, false, rand, villagePlanks);
            this.func_74882_a(world, box, 8, 2, 1, 8, 4, 4, false, rand, villagePlanks);
            this.func_74882_a(world, box, 1, 2, 0, 7, 4, 0, false, rand, villagePlanks);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 4, 2, 0, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 5, 2, 0, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 6, 2, 0, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 4, 3, 0, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 5, 3, 0, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 6, 3, 0, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 0, 2, 3, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 0, 3, 2, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 0, 3, 3, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 8, 2, 2, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 8, 2, 3, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 8, 3, 2, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 8, 3, 3, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 2, 2, 5, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 3, 2, 5, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 5, 2, 5, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 6, 2, 5, box);
            this.func_74882_a(world, box, 1, 4, 1, 7, 4, 1, false, rand, villagePlanks);
            this.func_74882_a(world, box, 1, 4, 4, 7, 4, 4, false, rand, villagePlanks);
            this.func_175804_a(world, box, 1, 3, 4, 7, 3, 4, NibiruBlocks.NIBIRU_BOOKSHELF.func_176223_P(), NibiruBlocks.NIBIRU_BOOKSHELF.func_176223_P(), false);
            this.func_175811_a(world, iblockstate4, 7, 1, 4, box);
            this.func_175811_a(world, iblockstate3, 7, 1, 3, box);
            this.func_175811_a(world, iblockstate1, 6, 1, 4, box);
            this.func_175811_a(world, iblockstate1, 5, 1, 4, box);
            this.func_175811_a(world, iblockstate1, 4, 1, 4, box);
            this.func_175811_a(world, iblockstate1, 3, 1, 4, box);
            this.func_175811_a(world, iblockstate6, 6, 1, 3, box);
            this.func_175811_a(world, Blocks.field_150452_aw.func_176223_P(), 6, 2, 3, box);
            this.func_175811_a(world, iblockstate6, 4, 1, 3, box);
            this.func_175811_a(world, Blocks.field_150452_aw.func_176223_P(), 4, 2, 3, box);
            this.func_175811_a(world, NibiruBlocks.NIBIRU_CRAFTING_TABLE.func_176223_P(), 7, 1, 1, box);
            this.func_186167_a(world, box, rand, 7, 2, 1, MPLootTables.NIBIRU_VILLAGE_LIBRARY);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 1, 1, 0, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 1, 2, 0, box);
            this.createVillageDoor(world, box, rand, 1, 1, 0);
            if (this.func_175807_a(world, 1, 0, -1, box).func_185904_a() == Material.field_151579_a && this.func_175807_a(world, 1, -1, -1, box).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(world, iblockstate5, 1, 0, -1, box);
                if (this.func_175807_a(world, 1, -1, -1, box).func_177230_c() == NibiruBlocks.NIBIRU_GRASS_PATH) {
                    this.func_175811_a(world, NibiruBlocks.INFECTED_GRASS.func_176223_P(), 1, -1, -1, box);
                }
            }
            for (int l = 0; l < 6; ++l) {
                for (int k = 0; k < 9; ++k) {
                    this.func_74871_b(world, k, 9, l, box);
                    this.func_175808_b(world, iblockstate, k, -1, l, box);
                }
            }
            this.spawnVillagers(world, box, 2, 1, 2, 1);
            return true;
        }

        @Override
        protected int chooseProfession(int villagersSpawned, int currentVillagerProfession) {
            return 1;
        }
    }

    public static class Hall
    extends Village {
        public Hall() {
        }

        public Hall(Start start, int type, StructureBoundingBox box, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = box;
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(world, box);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_BLOCK.func_176203_a(1));
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(NibiruBlocks.INFECTED_OAK_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(NibiruBlocks.INFECTED_OAK_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(NibiruBlocks.INFECTED_OAK_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_PLANKS.func_176223_P());
            IBlockState iblockstate5 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_LOG.func_176223_P());
            IBlockState iblockstate6 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_FENCE.func_176223_P());
            this.func_175804_a(world, box, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, box, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_74882_a(world, box, 2, 0, 6, 8, 0, 10, false, rand, villageDirts);
            this.func_175811_a(world, iblockstate, 6, 0, 6, box);
            this.func_175804_a(world, box, 2, 1, 6, 2, 1, 10, iblockstate6, iblockstate6, false);
            this.func_175804_a(world, box, 8, 1, 6, 8, 1, 10, iblockstate6, iblockstate6, false);
            this.func_175804_a(world, box, 3, 1, 10, 7, 1, 10, iblockstate6, iblockstate6, false);
            this.func_74882_a(world, box, 1, 0, 1, 7, 0, 4, false, rand, villagePlanks);
            this.func_74882_a(world, box, 0, 0, 0, 0, 3, 5, false, rand, villageStones);
            this.func_74882_a(world, box, 8, 0, 0, 8, 3, 5, false, rand, villageStones);
            this.func_74882_a(world, box, 1, 0, 0, 7, 1, 0, false, rand, villageStones);
            this.func_74882_a(world, box, 1, 0, 5, 7, 1, 5, false, rand, villageStones);
            this.func_74882_a(world, box, 1, 2, 0, 7, 3, 0, false, rand, villagePlanks);
            this.func_74882_a(world, box, 1, 2, 5, 7, 3, 5, false, rand, villagePlanks);
            this.func_74882_a(world, box, 0, 4, 1, 8, 4, 1, false, rand, villagePlanks);
            this.func_74882_a(world, box, 0, 4, 4, 8, 4, 4, false, rand, villagePlanks);
            this.func_74882_a(world, box, 0, 5, 2, 8, 5, 3, false, rand, villagePlanks);
            this.func_175811_a(world, iblockstate4, 0, 4, 2, box);
            this.func_175811_a(world, iblockstate4, 0, 4, 3, box);
            this.func_175811_a(world, iblockstate4, 8, 4, 2, box);
            this.func_175811_a(world, iblockstate4, 8, 4, 3, box);
            IBlockState iblockstate7 = iblockstate1;
            IBlockState iblockstate8 = iblockstate2;
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.func_175811_a(world, iblockstate7, j, 4 + i, i, box);
                    this.func_175811_a(world, iblockstate8, j, 4 + i, 5 - i, box);
                }
            }
            this.func_175811_a(world, iblockstate5, 0, 2, 1, box);
            this.func_175811_a(world, iblockstate5, 0, 2, 4, box);
            this.func_175811_a(world, iblockstate5, 8, 2, 1, box);
            this.func_175811_a(world, iblockstate5, 8, 2, 4, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 0, 2, 3, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 8, 2, 2, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 8, 2, 3, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 2, 2, 5, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 3, 2, 5, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 5, 2, 0, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 6, 2, 5, box);
            this.func_175811_a(world, iblockstate6, 2, 1, 3, box);
            this.func_175811_a(world, Blocks.field_150452_aw.func_176223_P(), 2, 2, 3, box);
            this.func_175811_a(world, iblockstate4, 1, 1, 4, box);
            this.func_175811_a(world, iblockstate7, 2, 1, 4, box);
            this.func_175811_a(world, iblockstate3, 1, 1, 3, box);
            this.func_175804_a(world, box, 5, 0, 1, 7, 0, 3, NibiruBlocks.DOUBLE_INFECTED_STONE_BRICKS_SLAB.func_176223_P(), NibiruBlocks.DOUBLE_INFECTED_STONE_BRICKS_SLAB.func_176223_P(), false);
            this.func_175811_a(world, NibiruBlocks.DOUBLE_INFECTED_STONE_BRICKS_SLAB.func_176223_P(), 6, 1, 1, box);
            this.func_175811_a(world, NibiruBlocks.DOUBLE_INFECTED_STONE_BRICKS_SLAB.func_176223_P(), 6, 1, 2, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, box);
            this.placeTorch(world, EnumFacing.NORTH, 2, 3, 1, box);
            this.createVillageDoor(world, box, rand, 2, 1, 0);
            if (this.func_175807_a(world, 2, 0, -1, box).func_185904_a() == Material.field_151579_a && this.func_175807_a(world, 2, -1, -1, box).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(world, iblockstate7, 2, 0, -1, box);
                if (this.func_175807_a(world, 2, -1, -1, box).func_177230_c() == NibiruBlocks.NIBIRU_GRASS_PATH) {
                    this.func_175811_a(world, NibiruBlocks.INFECTED_GRASS.func_176223_P(), 2, -1, -1, box);
                }
            }
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 6, 1, 5, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 6, 2, 5, box);
            this.placeTorch(world, EnumFacing.SOUTH, 6, 3, 4, box);
            this.createVillageDoor(world, box, rand, 6, 1, 5);
            for (int k = 0; k < 5; ++k) {
                for (int l = 0; l < 9; ++l) {
                    this.func_74871_b(world, l, 7, k, box);
                    this.func_175808_b(world, iblockstate, l, -1, k, box);
                }
            }
            this.spawnVillagers(world, box, 4, 1, 2, 2);
            return true;
        }

        @Override
        protected int chooseProfession(int villagersSpawned, int currentVillagerProfession) {
            return villagersSpawned == 0 ? 4 : super.chooseProfession(villagersSpawned, currentVillagerProfession);
        }
    }

    public static class Field2
    extends Village {
        private Block cropTypeA;
        private Block cropTypeB;

        public Field2() {
        }

        public Field2(Start start, int type, Random rand, StructureBoundingBox box, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = box;
            this.cropTypeA = this.getRandomCropType(rand);
            this.cropTypeB = this.getRandomCropType(rand);
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74768_a("CA", Block.field_149771_c.func_148757_b((Object)this.cropTypeA));
            nbt.func_74768_a("CB", Block.field_149771_c.func_148757_b((Object)this.cropTypeB));
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
            super.func_143011_b(nbt, manager);
            this.cropTypeA = Block.func_149729_e((int)nbt.func_74762_e("CA"));
            this.cropTypeB = Block.func_149729_e((int)nbt.func_74762_e("CB"));
        }

        private Block getRandomCropType(Random rand) {
            return this.structureType == 2 ? NibiruBlocks.TERRABERRY_BLOCK : NibiruBlocks.INFECTED_WHEAT_BLOCK;
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(world, box);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            this.func_175804_a(world, box, 0, 1, 0, 6, 4, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, box, 1, 0, 1, 2, 0, 7, NibiruBlocks.INFECTED_FARMLAND.func_176223_P(), NibiruBlocks.INFECTED_FARMLAND.func_176223_P(), false);
            this.func_175804_a(world, box, 4, 0, 1, 5, 0, 7, NibiruBlocks.INFECTED_FARMLAND.func_176223_P(), NibiruBlocks.INFECTED_FARMLAND.func_176223_P(), false);
            this.func_74882_a(world, box, 0, 0, 0, 0, 0, 8, false, rand, villageLogs);
            this.func_74882_a(world, box, 6, 0, 0, 6, 0, 8, false, rand, villageLogs);
            this.func_74882_a(world, box, 1, 0, 0, 5, 0, 0, false, rand, villageLogs);
            this.func_74882_a(world, box, 1, 0, 8, 5, 0, 8, false, rand, villageLogs);
            this.func_175804_a(world, box, 3, 0, 1, 3, 0, 7, NibiruBlocks.INFECTED_WATER_FLUID_BLOCK.func_176223_P(), NibiruBlocks.INFECTED_WATER_FLUID_BLOCK.func_176223_P(), false);
            for (int i = 1; i <= 7; ++i) {
                int j = ((BlockCropsMP)this.cropTypeA).getMaxAge();
                int k = j / 3;
                this.func_175811_a(world, this.cropTypeA.func_176203_a(MathHelper.func_76136_a((Random)rand, (int)k, (int)j)), 1, 1, i, box);
                this.func_175811_a(world, this.cropTypeA.func_176203_a(MathHelper.func_76136_a((Random)rand, (int)k, (int)j)), 2, 1, i, box);
                int l = ((BlockCropsMP)this.cropTypeB).getMaxAge();
                int i1 = l / 3;
                this.func_175811_a(world, this.cropTypeB.func_176203_a(MathHelper.func_76136_a((Random)rand, (int)i1, (int)l)), 4, 1, i, box);
                this.func_175811_a(world, this.cropTypeB.func_176203_a(MathHelper.func_76136_a((Random)rand, (int)i1, (int)l)), 5, 1, i, box);
            }
            for (int j1 = 0; j1 < 9; ++j1) {
                for (int k1 = 0; k1 < 7; ++k1) {
                    this.func_74871_b(world, k1, 4, j1, box);
                    this.func_175808_b(world, NibiruBlocks.INFECTED_DIRT.func_176223_P(), k1, -1, j1, box);
                }
            }
            return true;
        }
    }

    public static class Field1
    extends Village {
        private Block cropTypeA;
        private Block cropTypeB;
        private Block cropTypeC;
        private Block cropTypeD;

        public Field1() {
        }

        public Field1(Start start, int type, Random rand, StructureBoundingBox box, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = box;
            this.cropTypeA = this.getRandomCropType(rand);
            this.cropTypeB = this.getRandomCropType(rand);
            this.cropTypeC = this.getRandomCropType(rand);
            this.cropTypeD = this.getRandomCropType(rand);
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74768_a("CA", Block.field_149771_c.func_148757_b((Object)this.cropTypeA));
            nbt.func_74768_a("CB", Block.field_149771_c.func_148757_b((Object)this.cropTypeB));
            nbt.func_74768_a("CC", Block.field_149771_c.func_148757_b((Object)this.cropTypeC));
            nbt.func_74768_a("CD", Block.field_149771_c.func_148757_b((Object)this.cropTypeD));
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
            super.func_143011_b(nbt, manager);
            this.cropTypeA = Block.func_149729_e((int)nbt.func_74762_e("CA"));
            this.cropTypeB = Block.func_149729_e((int)nbt.func_74762_e("CB"));
            this.cropTypeC = Block.func_149729_e((int)nbt.func_74762_e("CC"));
            this.cropTypeD = Block.func_149729_e((int)nbt.func_74762_e("CD"));
        }

        private Block getRandomCropType(Random rand) {
            return this.structureType == 2 ? NibiruBlocks.TERRABERRY_BLOCK : NibiruBlocks.INFECTED_WHEAT_BLOCK;
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(world, box);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            this.func_175804_a(world, box, 0, 1, 0, 12, 4, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, box, 1, 0, 1, 2, 0, 7, NibiruBlocks.INFECTED_FARMLAND.func_176223_P(), NibiruBlocks.INFECTED_FARMLAND.func_176223_P(), false);
            this.func_175804_a(world, box, 4, 0, 1, 5, 0, 7, NibiruBlocks.INFECTED_FARMLAND.func_176223_P(), NibiruBlocks.INFECTED_FARMLAND.func_176223_P(), false);
            this.func_175804_a(world, box, 7, 0, 1, 8, 0, 7, NibiruBlocks.INFECTED_FARMLAND.func_176223_P(), NibiruBlocks.INFECTED_FARMLAND.func_176223_P(), false);
            this.func_175804_a(world, box, 10, 0, 1, 11, 0, 7, NibiruBlocks.INFECTED_FARMLAND.func_176223_P(), NibiruBlocks.INFECTED_FARMLAND.func_176223_P(), false);
            this.func_74882_a(world, box, 0, 0, 0, 0, 0, 8, false, rand, villageLogs);
            this.func_74882_a(world, box, 6, 0, 0, 6, 0, 8, false, rand, villageLogs);
            this.func_74882_a(world, box, 12, 0, 0, 12, 0, 8, false, rand, villageLogs);
            this.func_74882_a(world, box, 1, 0, 0, 11, 0, 0, false, rand, villageLogs);
            this.func_74882_a(world, box, 1, 0, 8, 11, 0, 8, false, rand, villageLogs);
            this.func_175804_a(world, box, 3, 0, 1, 3, 0, 7, NibiruBlocks.INFECTED_WATER_FLUID_BLOCK.func_176223_P(), NibiruBlocks.INFECTED_WATER_FLUID_BLOCK.func_176223_P(), false);
            this.func_175804_a(world, box, 9, 0, 1, 9, 0, 7, NibiruBlocks.INFECTED_WATER_FLUID_BLOCK.func_176223_P(), NibiruBlocks.INFECTED_WATER_FLUID_BLOCK.func_176223_P(), false);
            for (int i = 1; i <= 7; ++i) {
                int j = ((BlockCropsMP)this.cropTypeA).getMaxAge();
                int k = j / 3;
                this.func_175811_a(world, this.cropTypeA.func_176203_a(MathHelper.func_76136_a((Random)rand, (int)k, (int)j)), 1, 1, i, box);
                this.func_175811_a(world, this.cropTypeA.func_176203_a(MathHelper.func_76136_a((Random)rand, (int)k, (int)j)), 2, 1, i, box);
                int l = ((BlockCropsMP)this.cropTypeB).getMaxAge();
                int i1 = l / 3;
                this.func_175811_a(world, this.cropTypeB.func_176203_a(MathHelper.func_76136_a((Random)rand, (int)i1, (int)l)), 4, 1, i, box);
                this.func_175811_a(world, this.cropTypeB.func_176203_a(MathHelper.func_76136_a((Random)rand, (int)i1, (int)l)), 5, 1, i, box);
                int j1 = ((BlockCropsMP)this.cropTypeC).getMaxAge();
                int k1 = j1 / 3;
                this.func_175811_a(world, this.cropTypeC.func_176203_a(MathHelper.func_76136_a((Random)rand, (int)k1, (int)j1)), 7, 1, i, box);
                this.func_175811_a(world, this.cropTypeC.func_176203_a(MathHelper.func_76136_a((Random)rand, (int)k1, (int)j1)), 8, 1, i, box);
                int l1 = ((BlockCropsMP)this.cropTypeD).getMaxAge();
                int i2 = l1 / 3;
                this.func_175811_a(world, this.cropTypeD.func_176203_a(MathHelper.func_76136_a((Random)rand, (int)i2, (int)l1)), 10, 1, i, box);
                this.func_175811_a(world, this.cropTypeD.func_176203_a(MathHelper.func_76136_a((Random)rand, (int)i2, (int)l1)), 11, 1, i, box);
            }
            for (int j2 = 0; j2 < 9; ++j2) {
                for (int k2 = 0; k2 < 13; ++k2) {
                    this.func_74871_b(world, k2, 4, j2, box);
                    this.func_175808_b(world, NibiruBlocks.INFECTED_DIRT.func_176223_P(), k2, -1, j2, box);
                }
            }
            return true;
        }
    }

    public static class Church
    extends Village {
        public Church() {
        }

        public Church(Start start, int type, StructureBoundingBox box, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = box;
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(world, box);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 12 - 1, 0);
            }
            IBlockState iblockstate = NibiruBlocks.NIBIRU_BLOCK.func_176203_a(1);
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_COBBLESTONE_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_COBBLESTONE_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(NibiruBlocks.NIBIRU_COBBLESTONE_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
            this.func_175804_a(world, box, 1, 1, 1, 3, 3, 7, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, box, 1, 5, 1, 3, 9, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_74882_a(world, box, 1, 0, 0, 3, 0, 8, false, rand, villageStones);
            this.func_74882_a(world, box, 1, 1, 0, 3, 10, 0, false, rand, villageStones);
            this.func_74882_a(world, box, 0, 1, 1, 0, 10, 3, false, rand, villageStones);
            this.func_74882_a(world, box, 4, 1, 1, 4, 10, 3, false, rand, villageStones);
            this.func_74882_a(world, box, 0, 0, 4, 0, 4, 7, false, rand, villageStones);
            this.func_74882_a(world, box, 4, 0, 4, 4, 4, 7, false, rand, villageStones);
            this.func_74882_a(world, box, 1, 1, 8, 3, 4, 8, false, rand, villageStones);
            this.func_74882_a(world, box, 1, 5, 4, 3, 10, 4, false, rand, villageStones);
            this.func_74882_a(world, box, 1, 5, 5, 3, 5, 7, false, rand, villageStones);
            this.func_74882_a(world, box, 0, 9, 0, 4, 9, 4, false, rand, villageStones);
            this.func_74882_a(world, box, 0, 4, 0, 4, 4, 4, false, rand, villageStones);
            this.func_175811_a(world, iblockstate, 0, 11, 2, box);
            this.func_175811_a(world, iblockstate, 4, 11, 2, box);
            this.func_175811_a(world, iblockstate, 2, 11, 0, box);
            this.func_175811_a(world, iblockstate, 2, 11, 4, box);
            this.func_175811_a(world, iblockstate, 1, 1, 6, box);
            this.func_175811_a(world, iblockstate, 1, 1, 7, box);
            this.func_175811_a(world, iblockstate, 2, 1, 7, box);
            this.func_175811_a(world, iblockstate, 3, 1, 6, box);
            this.func_175811_a(world, iblockstate, 3, 1, 7, box);
            this.func_175811_a(world, iblockstate1, 1, 1, 5, box);
            this.func_175811_a(world, iblockstate1, 2, 1, 6, box);
            this.func_175811_a(world, iblockstate1, 3, 1, 5, box);
            this.func_175811_a(world, iblockstate2, 1, 2, 7, box);
            this.func_175811_a(world, iblockstate3, 3, 2, 7, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 0, 3, 2, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 4, 2, 2, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 4, 3, 2, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 0, 6, 2, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 0, 7, 2, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 4, 6, 2, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 4, 7, 2, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 2, 6, 0, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 2, 7, 0, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 2, 6, 4, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 2, 7, 4, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 0, 3, 6, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 4, 3, 6, box);
            this.func_175811_a(world, rand.nextInt(5) == 0 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150410_aZ.func_176223_P(), 2, 3, 8, box);
            this.placeTorch(world, EnumFacing.SOUTH, 2, 4, 7, box);
            this.placeTorch(world, EnumFacing.EAST, 1, 4, 6, box);
            this.placeTorch(world, EnumFacing.WEST, 3, 4, 6, box);
            this.placeTorch(world, EnumFacing.NORTH, 2, 4, 5, box);
            IBlockState iblockstate4 = Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.WEST);
            for (int i = 1; i <= 9; ++i) {
                this.func_175811_a(world, iblockstate4, 3, i, 3, box);
            }
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, box);
            this.createVillageDoor(world, box, rand, 2, 1, 0);
            if (this.func_175807_a(world, 2, 0, -1, box).func_185904_a() == Material.field_151579_a && this.func_175807_a(world, 2, -1, -1, box).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(world, iblockstate1, 2, 0, -1, box);
                if (this.func_175807_a(world, 2, -1, -1, box).func_177230_c() == NibiruBlocks.NIBIRU_GRASS_PATH) {
                    this.func_175811_a(world, NibiruBlocks.INFECTED_GRASS.func_176223_P(), 2, -1, -1, box);
                }
            }
            for (int k = 0; k < 9; ++k) {
                for (int j = 0; j < 5; ++j) {
                    this.func_74871_b(world, j, 12, k, box);
                    this.func_175808_b(world, iblockstate, j, -1, k, box);
                }
            }
            this.spawnVillagers(world, box, 2, 1, 2, 1);
            return true;
        }

        @Override
        protected int chooseProfession(int villagersSpawnedIn, int currentVillagerProfession) {
            return 2;
        }
    }
}

