/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenerator;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.NibiruBlocks;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.feature.WorldGenAlienBerryBigTree;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.feature.WorldGenAlienBerryTree;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.feature.WorldGenInfectedBigTree;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.feature.WorldGenInfectedJungleTrees;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.feature.WorldGenInfectedMegaJungle;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.feature.WorldGenInfectedTrees;
import stevekung.mods.moreplanets.util.VariantsName;
import stevekung.mods.moreplanets.util.blocks.BlockBushMP;
import stevekung.mods.moreplanets.util.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.util.blocks.IBlockVariants;

public class BlockNibiruSapling
extends BlockBushMP
implements IBlockVariants,
IGrowable {
    public static PropertyEnum<BlockType> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockType.class);
    protected static AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);

    public BlockNibiruSapling(String name) {
        this.func_180632_j(this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.INFECTED_OAK_SAPLING)));
        this.func_149663_c(name);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return SAPLING_AABB;
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int i = 0; i < BlockType.valuesCached().length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        int meta = this.func_176201_c(state);
        Block block = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (meta == 3) {
            return block == NibiruBlocks.GREEN_VEIN_GRASS || block == NibiruBlocks.INFECTED_DIRT;
        }
        return block == NibiruBlocks.INFECTED_GRASS || block == NibiruBlocks.INFECTED_DIRT || block == NibiruBlocks.INFECTED_FARMLAND;
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        this.canBlockStay(world, pos, state);
        if (!world.field_72995_K) {
            super.func_180650_b(world, pos, state, rand);
            if (world.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.func_176474_b(world, rand, pos, state);
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory(int meta) {
        return EnumSortCategoryBlock.SAPLING;
    }

    @Override
    public VariantsName getVariantsName() {
        return new VariantsName("infected_oak", "infected_dead_oak", "infected_jungle", "alien_berry");
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return (double)world.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        int meta = this.func_176201_c(state);
        WorldGenAbstractTree obj = null;
        int i = 0;
        int j = 0;
        boolean flag = false;
        if (obj == null) {
            switch (meta) {
                case 0: {
                    obj = rand.nextInt(10) == 0 ? new WorldGenInfectedBigTree(true, NibiruBlocks.NIBIRU_LOG, 0, NibiruBlocks.NIBIRU_LEAVES, 0) : new WorldGenInfectedTrees(true, NibiruBlocks.NIBIRU_LOG.func_176223_P(), NibiruBlocks.NIBIRU_LEAVES.func_176223_P());
                    break;
                }
                case 1: {
                    obj = rand.nextInt(10) == 0 ? new WorldGenInfectedBigTree(true, NibiruBlocks.NIBIRU_LOG, 1, NibiruBlocks.NIBIRU_LEAVES, 1) : new WorldGenInfectedTrees(true, NibiruBlocks.NIBIRU_LOG.func_176203_a(1), NibiruBlocks.NIBIRU_LEAVES.func_176203_a(1));
                    break;
                }
                case 2: {
                    block6: for (i = 0; i >= -1; --i) {
                        for (j = 0; j >= -1; --j) {
                            if (!this.isTwoByTwoOfType(world, pos, i, j)) continue;
                            obj = new WorldGenInfectedMegaJungle(true, 10, 20);
                            flag = true;
                            break block6;
                        }
                    }
                    if (flag) break;
                    j = 0;
                    i = 0;
                    obj = new WorldGenInfectedJungleTrees(true, 4 + rand.nextInt(7), false);
                    break;
                }
                case 3: {
                    WorldGenAbstractTree worldGenAbstractTree = obj = rand.nextInt(10) == 0 ? new WorldGenAlienBerryBigTree() : new WorldGenAlienBerryTree();
                }
            }
        }
        if (obj != null) {
            IBlockState iblockstate2 = Blocks.field_150350_a.func_176223_P();
            if (flag) {
                world.func_180501_a(pos.func_177982_a(i, 0, j), iblockstate2, 4);
                world.func_180501_a(pos.func_177982_a(i + 1, 0, j), iblockstate2, 4);
                world.func_180501_a(pos.func_177982_a(i, 0, j + 1), iblockstate2, 4);
                world.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), iblockstate2, 4);
            } else {
                world.func_180501_a(pos, iblockstate2, 4);
            }
            if (!((WorldGenerator)obj).func_180709_b(world, rand, pos.func_177982_a(i, 0, j))) {
                if (flag) {
                    world.func_180501_a(pos.func_177982_a(i, 0, j), state, 4);
                    world.func_180501_a(pos.func_177982_a(i + 1, 0, j), state, 4);
                    world.func_180501_a(pos.func_177982_a(i, 0, j + 1), state, 4);
                    world.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), state, 4);
                } else {
                    world.func_180501_a(pos, state, 4);
                }
            }
        }
    }

    private boolean isTwoByTwoOfType(World world, BlockPos pos, int x, int z) {
        return this.isTypeAt(world, pos.func_177982_a(x, 0, z)) && this.isTypeAt(world, pos.func_177982_a(x + 1, 0, z)) && this.isTypeAt(world, pos.func_177982_a(x, 0, z + 1)) && this.isTypeAt(world, pos.func_177982_a(x + 1, 0, z + 1));
    }

    public boolean isTypeAt(World world, BlockPos pos) {
        IBlockState iblockstate = world.func_180495_p(pos);
        return iblockstate.func_177230_c() == this && iblockstate.func_177229_b(VARIANT) == BlockType.INFECTED_JUNGLE_SAPLING;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.valuesCached()[meta % BlockType.valuesCached().length]));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public static enum BlockType implements IStringSerializable
    {
        INFECTED_OAK_SAPLING,
        INFECTED_DEAD_OAK_SAPLING,
        INFECTED_JUNGLE_SAPLING,
        ALIEN_BERRY_SAPLING;

        private static BlockType[] values;

        public static BlockType[] valuesCached() {
            return values;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            values = BlockType.values();
        }
    }
}

