/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.mjrlegendslib.util;

import com.mjr.mjrlegendslib.util.MessageUtilities;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class NetworkUtilities {
    public static void registerGuiHandler(Object mod, IGuiHandler handler) {
        NetworkRegistry.INSTANCE.registerGuiHandler(mod, handler);
    }

    public static void encodeData(ByteBuf buffer, Collection<Object> sendData) throws IOException {
        for (Object dataValue : sendData) {
            int i;
            if (dataValue instanceof Integer) {
                buffer.writeInt(((Integer)dataValue).intValue());
                continue;
            }
            if (dataValue instanceof Float) {
                buffer.writeFloat(((Float)dataValue).floatValue());
                continue;
            }
            if (dataValue instanceof Double) {
                buffer.writeDouble(((Double)dataValue).doubleValue());
                continue;
            }
            if (dataValue instanceof Byte) {
                buffer.writeByte((int)((Byte)dataValue).byteValue());
                continue;
            }
            if (dataValue instanceof Boolean) {
                buffer.writeBoolean(((Boolean)dataValue).booleanValue());
                continue;
            }
            if (dataValue instanceof String) {
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)((String)dataValue));
                continue;
            }
            if (dataValue instanceof Short) {
                buffer.writeShort((int)((Short)dataValue).shortValue());
                continue;
            }
            if (dataValue instanceof Long) {
                buffer.writeLong(((Long)dataValue).longValue());
                continue;
            }
            if (dataValue instanceof Entity) {
                buffer.writeInt(((Entity)dataValue).func_145782_y());
                continue;
            }
            if (dataValue instanceof byte[]) {
                int size = ((byte[])dataValue).length;
                buffer.writeInt(size);
                int pos = buffer.writerIndex();
                buffer.capacity(pos + size);
                buffer.setBytes(pos, (byte[])dataValue);
                buffer.writerIndex(pos + size);
                continue;
            }
            if (dataValue instanceof UUID) {
                buffer.writeLong(((UUID)dataValue).getLeastSignificantBits());
                buffer.writeLong(((UUID)dataValue).getMostSignificantBits());
                continue;
            }
            if (dataValue instanceof Integer[]) {
                Integer[] array = (Integer[])dataValue;
                buffer.writeInt(array.length);
                for (i = 0; i < array.length; ++i) {
                    buffer.writeInt(array[i].intValue());
                }
                continue;
            }
            if (dataValue instanceof String[]) {
                String[] array = (String[])dataValue;
                buffer.writeInt(array.length);
                for (i = 0; i < array.length; ++i) {
                    ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)array[i]);
                }
                continue;
            }
            if (dataValue instanceof EnumFacing) {
                buffer.writeInt(((EnumFacing)dataValue).func_176745_a());
                continue;
            }
            if (dataValue instanceof BlockPos) {
                BlockPos pos = (BlockPos)dataValue;
                buffer.writeInt(pos.func_177958_n());
                buffer.writeInt(pos.func_177956_o());
                buffer.writeInt(pos.func_177952_p());
                continue;
            }
            if (dataValue instanceof EnumDyeColor) {
                buffer.writeInt(((EnumDyeColor)dataValue).func_176767_b());
                continue;
            }
            if (dataValue == null) {
                MessageUtilities.fatalErrorMessageToLog("mjrlegendslib", "Cannot construct PacketSimple with null data, this is a bug.");
            }
            MessageUtilities.fatalErrorMessageToLog("mjrlegendslib", "Could not find data type to encode!: " + dataValue);
        }
    }

    public static ArrayList<Object> decodeData(Class<?>[] types, ByteBuf buffer) {
        ArrayList<Object> objList = new ArrayList<Object>();
        for (Class<?> clazz : types) {
            int size;
            if (clazz.equals(Integer.class)) {
                objList.add(buffer.readInt());
                continue;
            }
            if (clazz.equals(Float.class)) {
                objList.add(Float.valueOf(buffer.readFloat()));
                continue;
            }
            if (clazz.equals(Double.class)) {
                objList.add(buffer.readDouble());
                continue;
            }
            if (clazz.equals(Byte.class)) {
                objList.add(buffer.readByte());
                continue;
            }
            if (clazz.equals(Boolean.class)) {
                objList.add(buffer.readBoolean());
                continue;
            }
            if (clazz.equals(String.class)) {
                objList.add(ByteBufUtils.readUTF8String((ByteBuf)buffer));
                continue;
            }
            if (clazz.equals(Short.class)) {
                objList.add(buffer.readShort());
                continue;
            }
            if (clazz.equals(Long.class)) {
                objList.add(buffer.readLong());
                continue;
            }
            if (clazz.equals(byte[].class)) {
                size = buffer.readInt();
                byte[] bytes = new byte[size];
                buffer.readBytes(bytes, 0, size);
                objList.add(bytes);
                continue;
            }
            if (clazz.equals(UUID.class)) {
                objList.add(new UUID(buffer.readLong(), buffer.readLong()));
                continue;
            }
            if (clazz.equals(Integer[].class)) {
                size = buffer.readInt();
                for (int i = 0; i < size; ++i) {
                    objList.add(buffer.readInt());
                }
                continue;
            }
            if (clazz.equals(String[].class)) {
                size = buffer.readInt();
                for (int i = 0; i < size; ++i) {
                    objList.add(ByteBufUtils.readUTF8String((ByteBuf)buffer));
                }
                continue;
            }
            if (clazz.equals(EnumFacing.class)) {
                objList.add(EnumFacing.func_82600_a((int)buffer.readInt()));
                continue;
            }
            if (clazz.equals(BlockPos.class)) {
                objList.add(new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt()));
                continue;
            }
            if (!clazz.equals(EnumDyeColor.class)) continue;
            objList.add(EnumDyeColor.func_176766_a((int)buffer.readInt()));
        }
        return objList;
    }
}

