/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeUniquelyNamed;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeItemStackLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;

public class ValueObjectTypeItemStack
extends ValueObjectTypeBase<ValueItemStack>
implements IValueTypeNamed<ValueItemStack>,
IValueTypeUniquelyNamed<ValueItemStack>,
IValueTypeNullable<ValueItemStack> {
    public ValueObjectTypeItemStack() {
        super("itemstack");
    }

    public static String getItemStackDisplayNameUsSafe(ItemStack itemStack) throws NoSuchMethodException {
        return !itemStack.func_190926_b() ? itemStack.func_82833_r() + (itemStack.func_190916_E() > 1 ? " (" + itemStack.func_190916_E() + ")" : "") : "";
    }

    public static String getItemStackDisplayNameSafe(ItemStack itemStack) {
        try {
            return ValueObjectTypeItemStack.getItemStackDisplayNameUsSafe(itemStack);
        }
        catch (NoSuchMethodException e) {
            return L10NHelpers.localize((String)(itemStack.func_77977_a() + ".name"), (Object[])new Object[0]);
        }
    }

    @Override
    public ValueItemStack getDefault() {
        return ValueItemStack.of(ItemStack.field_190927_a);
    }

    @Override
    public String toCompactString(ValueItemStack value) {
        return ValueObjectTypeItemStack.getItemStackDisplayNameSafe(value.getRawValue());
    }

    @Override
    public String serialize(ValueItemStack value) {
        NBTTagCompound tag = new NBTTagCompound();
        ItemStack itemStack = value.getRawValue();
        if (!itemStack.func_190926_b()) {
            itemStack.func_77955_b(tag);
            tag.func_74768_a("Count", itemStack.func_190916_E());
        }
        return tag.toString();
    }

    @Override
    public ValueItemStack deserialize(String value) {
        try {
            NBTTagCompound tag = JsonToNBT.func_180713_a((String)value);
            int realCount = tag.func_74762_e("Count");
            tag.func_74774_a("Count", (byte)1);
            ItemStack itemStack = new ItemStack(tag);
            if (!itemStack.func_190926_b()) {
                itemStack.func_190920_e(realCount);
            }
            return ValueItemStack.of(itemStack);
        }
        catch (NBTException e) {
            return ValueItemStack.of(ItemStack.field_190927_a);
        }
    }

    @Override
    public String getName(ValueItemStack a) {
        return this.toCompactString(a);
    }

    @Override
    public boolean isNull(ValueItemStack a) {
        return a.getRawValue().func_190926_b();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeItemStackLPElement<ValueItemStack>(this, new ValueTypeItemStackLPElement.IItemStackToValue<ValueItemStack>(){

            @Override
            public boolean isNullable() {
                return true;
            }

            @Override
            public L10NHelpers.UnlocalizedString validate(ItemStack itemStack) {
                return null;
            }

            @Override
            public ValueItemStack getValue(ItemStack itemStack) {
                return ValueItemStack.of(itemStack);
            }
        });
    }

    @Override
    public ValuePredicate<ValueItemStack> deserializeValuePredicate(JsonObject element, @Nullable IValue value) {
        JsonElement jsonElement = element.get("value");
        ItemPredicate itemPredicate = null;
        if (jsonElement != null && !jsonElement.isJsonNull()) {
            itemPredicate = ItemPredicate.func_192492_a((JsonElement)element.get("value"));
        }
        return new ValueItemStackPredicate(this, value, itemPredicate);
    }

    @Override
    public ValueItemStack materialize(ValueItemStack value) throws EvaluationException {
        return ValueItemStack.of(value.getRawValue().func_77946_l());
    }

    @Override
    public String getUniqueName(ValueItemStack value) {
        ItemStack itemStack = value.getRawValue();
        return !itemStack.func_190926_b() ? itemStack.func_77973_b().getRegistryName() + (itemStack.func_77960_j() > 0 ? " " + itemStack.func_77960_j() : "") : "";
    }

    public static class ValueItemStackPredicate
    extends ValuePredicate<ValueItemStack> {
        @Nullable
        private final ItemPredicate itemPredicate;

        public ValueItemStackPredicate(@Nullable IValueType valueType, @Nullable IValue value, @Nullable ItemPredicate itemPredicate) {
            super(valueType, value);
            this.itemPredicate = itemPredicate;
        }

        @Override
        protected boolean testTyped(ValueItemStack value) {
            return super.testTyped(value) && (this.itemPredicate == null || this.itemPredicate.func_192493_a(value.getRawValue()));
        }
    }

    public static class ValueItemStack
    extends ValueBase {
        private final ItemStack itemStack;

        private ValueItemStack(ItemStack itemStack) {
            super(ValueTypes.OBJECT_ITEMSTACK);
            this.itemStack = Objects.requireNonNull(itemStack, "Attempted to create a ValueItemStack for a null ItemStack.");
        }

        public static ValueItemStack of(ItemStack itemStack) {
            return new ValueItemStack(itemStack);
        }

        public ItemStack getRawValue() {
            return this.itemStack;
        }

        public boolean equals(Object o) {
            return o instanceof ValueItemStack && ItemMatch.areItemStacksEqual((ItemStack)((ValueItemStack)o).itemStack, (ItemStack)this.itemStack, (int)15);
        }

        public int hashCode() {
            return 37 + ItemStackHelpers.getItemStackHashCode((ItemStack)this.itemStack);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeItemStack.ValueItemStack(itemStack=" + this.itemStack + ")";
        }
    }
}

