/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;

public abstract class OperatorBase
implements IOperator {
    private final String symbol;
    private final String operatorName;
    private final IValueType[] inputTypes;
    private final IValueType outputType;
    private final IFunction function;
    @Nullable
    private final IConfigRenderPattern renderPattern;
    private String translationKey = null;
    private int recursiveInvocations;

    protected OperatorBase(String symbol, String operatorName, IValueType[] inputTypes, IValueType outputType, IFunction function, @Nullable IConfigRenderPattern renderPattern) {
        this.symbol = symbol;
        this.operatorName = operatorName;
        this.inputTypes = inputTypes;
        this.outputType = outputType;
        this.function = function;
        this.renderPattern = renderPattern;
        if (renderPattern != null && renderPattern.getSlotPositions().length != inputTypes.length) {
            throw new IllegalArgumentException(String.format("The given config render pattern with %s slots is not compatible with the number of input types %s for %s", renderPattern.getSlotPositions().length, inputTypes.length, symbol));
        }
    }

    public static IValueType[] constructInputVariables(int length, IValueType defaultType) {
        Object[] values = new IValueType[length];
        Arrays.fill(values, defaultType);
        return values;
    }

    protected abstract String getUnlocalizedType();

    protected IFunction getFunction() {
        return this.function;
    }

    @Override
    public String getUniqueName() {
        return this.getTranslationKey();
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey != null ? this.translationKey : (this.translationKey = this.getUnlocalizedPrefix() + ".name");
    }

    @Override
    public String getUnlocalizedCategoryName() {
        return this.getUnlocalizedCategoryPrefix() + ".name";
    }

    @Override
    public String getLocalizedNameFull() {
        return L10NHelpers.localize((String)(this.getUnlocalizedCategoryPrefix() + ".basename"), (Object[])new Object[]{L10NHelpers.localize((String)this.getTranslationKey(), (Object[])new Object[0])});
    }

    protected String getUnlocalizedPrefix() {
        return "operator.operators." + this.getModId() + "." + this.getUnlocalizedType() + "." + this.getOperatorName();
    }

    protected String getUnlocalizedCategoryPrefix() {
        return "operator.operators." + this.getModId() + "." + this.getUnlocalizedType();
    }

    protected String getOperatorName() {
        return this.operatorName;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public void loadTooltip(List<String> lines, boolean appendOptionalInfo) {
        String operatorName = L10NHelpers.localize((String)this.getTranslationKey(), (Object[])new Object[0]);
        String categoryName = L10NHelpers.localize((String)this.getUnlocalizedCategoryName(), (Object[])new Object[0]);
        String symbol = this.getSymbol();
        String outputTypeName = L10NHelpers.localize((String)this.getOutputType().getTranslationKey(), (Object[])new Object[0]);
        lines.add(L10NHelpers.localize((String)"operator.integrateddynamics.tooltip.operator_name", (Object[])new Object[]{operatorName, symbol}));
        lines.add(L10NHelpers.localize((String)"operator.integrateddynamics.tooltip.operator_category", (Object[])new Object[]{categoryName}));
        IValueType[] inputTypes = this.getInputTypes();
        for (int i = 0; i < inputTypes.length; ++i) {
            lines.add(L10NHelpers.localize((String)"operator.integrateddynamics.tooltip.input_type_name", (Object[])new Object[]{i + 1, inputTypes[i].getDisplayColorFormat() + L10NHelpers.localize((String)inputTypes[i].getTranslationKey(), (Object[])new Object[0])}));
        }
        lines.add(L10NHelpers.localize((String)"operator.integrateddynamics.tooltip.output_type_name", (Object[])new Object[]{this.getOutputType().getDisplayColorFormat() + outputTypeName}));
        if (appendOptionalInfo) {
            L10NHelpers.addOptionalInfo(lines, (String)this.getUnlocalizedPrefix());
        }
    }

    @Override
    public IValueType[] getInputTypes() {
        return this.inputTypes;
    }

    @Override
    public IValueType getOutputType() {
        return this.outputType;
    }

    @Override
    public IValueType getConditionalOutputType(IVariable[] input) {
        return this.outputType;
    }

    @Override
    public IValue evaluate(IVariable ... input) throws EvaluationException {
        if (this.recursiveInvocations++ > GeneralConfig.operatorRecursionLimit) {
            this.recursiveInvocations = 0;
            throw new EvaluationException(new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.operator_recursion_limit", new Object[]{GeneralConfig.operatorRecursionLimit, new L10NHelpers.UnlocalizedString(this.getTranslationKey(), new Object[0])}).localize());
        }
        L10NHelpers.UnlocalizedString error = this.validateTypes(ValueHelpers.from(input));
        if (error != null) {
            --this.recursiveInvocations;
            throw new EvaluationException(error.localize());
        }
        IValue res = this.function.evaluate(new SafeVariablesGetter(input));
        --this.recursiveInvocations;
        return res;
    }

    @Override
    public int getRequiredInputLength() {
        return this.getInputTypes().length;
    }

    @Override
    public L10NHelpers.UnlocalizedString validateTypes(IValueType[] input) {
        int requiredInputLength = this.getRequiredInputLength();
        if (input.length != requiredInputLength) {
            return new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.wrong_input_length", new Object[]{this.getOperatorName(), input.length, requiredInputLength});
        }
        for (int i = 0; i < requiredInputLength; ++i) {
            IValueType inputType = input[i];
            if (inputType == null) {
                return new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.null_type", new Object[]{this.getOperatorName(), Integer.toString(i)});
            }
            if (ValueHelpers.correspondsTo(this.getInputTypes()[i], inputType)) continue;
            return new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.wrong_type", new Object[]{this.getOperatorName(), new L10NHelpers.UnlocalizedString(inputType.getTranslationKey(), new Object[0]), Integer.toString(i + 1), new L10NHelpers.UnlocalizedString(this.getInputTypes()[i].getTranslationKey(), new Object[0])});
        }
        return null;
    }

    public String toString() {
        return "[Operator: " + this.getOperatorName() + "]";
    }

    protected String getModId() {
        return "integrateddynamics";
    }

    @Override
    @Nullable
    public IConfigRenderPattern getRenderPattern() {
        return this.renderPattern;
    }

    @Override
    public IOperator materialize() throws EvaluationException {
        return this;
    }

    public static interface IFunction {
        public IValue evaluate(SafeVariablesGetter var1) throws EvaluationException;
    }

    public static class SafeVariablesGetter {
        private final IVariable[] variables;

        public SafeVariablesGetter(IVariable ... variables) {
            this.variables = variables;
        }

        public <V extends IValue> V getValue(int i) throws EvaluationException {
            try {
                return this.variables[i].getValue();
            }
            catch (ClassCastException e) {
                throw new EvaluationException(e.getMessage());
            }
        }

        public IVariable[] getVariables() {
            return this.variables;
        }

        public static class Shifted
        extends SafeVariablesGetter {
            public Shifted(int start, IVariable ... variables) {
                super(Arrays.copyOfRange(variables, start, variables.length));
            }
        }
    }
}

