/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.advancement.criterion;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.cyclops.cyclopscore.advancement.criterion.BaseCriterionTrigger;
import org.cyclops.cyclopscore.advancement.criterion.ICriterionInstanceTestable;
import org.cyclops.integrateddynamics.core.network.event.NetworkInitializedEvent;

public class NetworkInitializedTrigger
extends BaseCriterionTrigger<NetworkInitializedEvent, Instance> {
    public NetworkInitializedTrigger() {
        super(new ResourceLocation("integrateddynamics", "network_initialized"));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        return new Instance(this.func_192163_a(), json.get("min_cables").getAsInt());
    }

    @SubscribeEvent
    public void onCrafted(NetworkInitializedEvent event) {
        if (event.getPlacer() != null && event.getPlacer() instanceof EntityPlayerMP) {
            this.trigger((EntityPlayerMP)event.getPlacer(), (Object)event);
        }
    }

    public static class Instance
    extends AbstractCriterionInstance
    implements ICriterionInstanceTestable<NetworkInitializedEvent> {
        private final int minCablesCount;

        public Instance(ResourceLocation criterionIn, int minCablesCount) {
            super(criterionIn);
            this.minCablesCount = minCablesCount;
        }

        public boolean test(EntityPlayerMP player, NetworkInitializedEvent networkEvent) {
            return networkEvent.getNetwork().getCablesCount() >= this.minCablesCount;
        }
    }
}

