/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.refinedstorage.aspect;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyPositioned;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamicscompat.modcompat.refinedstorage.RefinedStorageModCompat;
import org.cyclops.integrateddynamicscompat.modcompat.refinedstorage.aspect.LazyCompositeList;

public class ValueTypeListProxyPositionedNetworkMasterItemInventory
extends ValueTypeListProxyPositioned<ValueObjectTypeItemStack, ValueObjectTypeItemStack.ValueItemStack>
implements INBTProvider {
    public ValueTypeListProxyPositionedNetworkMasterItemInventory() {
        this(null);
    }

    public ValueTypeListProxyPositionedNetworkMasterItemInventory(DimPos pos) {
        super(RefinedStorageModCompat.POSITIONED_MASTERITEMINVENTORY.getName(), ValueTypes.OBJECT_ITEMSTACK, pos, EnumFacing.NORTH);
    }

    protected Optional<INetworkNode> getNetworkMaster() {
        return Optional.fromNullable((Object)TileHelpers.getSafeTile((DimPos)this.getPos(), INetworkNode.class));
    }

    protected Optional<List<ItemStack>> getInventory() {
        return this.getNetworkMaster().transform((Function)new Function<INetworkNode, List<ItemStack>>(){

            @Nullable
            public List<ItemStack> apply(@Nullable INetworkNode networkMaster) {
                if (networkMaster == null) {
                    return null;
                }
                List itemStacksLists = Lists.transform((List)networkMaster.getNetwork().getItemStorageCache().getStorages(), (Function)new Function<IStorage<ItemStack>, List<ItemStack>>(){

                    @Nullable
                    public List<ItemStack> apply(@Nullable IStorage<ItemStack> itemStorage) {
                        Collection stacks = itemStorage.getStacks();
                        return stacks instanceof List ? (List)stacks : Lists.newArrayList((Iterable)stacks);
                    }
                });
                return new LazyCompositeList<ItemStack>(itemStacksLists);
            }
        });
    }

    @Override
    public int getLength() {
        return ((List)this.getInventory().or(Collections.emptyList())).size();
    }

    @Override
    public ValueObjectTypeItemStack.ValueItemStack get(int index) {
        return ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)((List)this.getInventory().or(Collections.emptyList())).get(index));
    }

    @Override
    public void writeGeneratedFieldsToNBT(NBTTagCompound tag) {
    }

    @Override
    public void readGeneratedFieldsFromNBT(NBTTagCompound tag) {
    }
}

