/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.part;

import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class PartTarget {
    private final PartPos center;
    private final PartPos target;

    public static PartTarget fromCenter(DimPos pos, @Nullable EnumFacing side) {
        return PartTarget.of(PartPos.of(pos, side), PartPos.of(DimPos.of((int)pos.getDimensionId(), (BlockPos)(side == null ? pos.getBlockPos() : pos.getBlockPos().func_177972_a(side))), side == null ? null : side.func_176734_d()));
    }

    public static PartTarget fromCenter(PartPos pos) {
        return PartTarget.fromCenter(pos.getPos(), pos.getSide());
    }

    public static PartTarget fromCenter(World world, BlockPos pos, EnumFacing side) {
        return PartTarget.fromCenter(DimPos.of((World)world, (BlockPos)pos), side);
    }

    public static PartTarget of(PartPos center, PartPos target) {
        return new PartTarget(center, target);
    }

    public PartPos getCenter() {
        return this.center;
    }

    public PartPos getTarget() {
        return this.target;
    }

    private PartTarget(PartPos center, PartPos target) {
        this.center = center;
        this.target = target;
    }

    public PartTarget forTargetSide(EnumFacing targetSide) {
        return new PartTarget(this.center, PartPos.of(this.target.getPos(), targetSide));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartTarget)) {
            return false;
        }
        PartTarget that = (PartTarget)o;
        if (!this.center.equals(that.center)) {
            return false;
        }
        return this.target.equals(that.target);
    }

    public int hashCode() {
        int result = this.center.hashCode();
        result = 31 * result + this.target.hashCode();
        return result;
    }

    public String toString() {
        return "PartTarget{center=" + this.center + ", target=" + this.target + '}';
    }
}

