/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockTypes_MetalsAll;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorVertical;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class ConveyorChute
extends ConveyorVertical {
    private static final String NBT_POS = "immersiveengineering:chutePos";
    private static final String NBT_TIME = "immersiveengineering:chuteTime";
    private int sheetmetalType = BlockTypes_MetalsAll.IRON.getMeta();
    private boolean diagonal = false;
    static final List<AxisAlignedBB> selectionBoxes = Collections.singletonList(Block.field_185505_j);
    static final AxisAlignedBB[] bounds = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625), new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0), new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0)};
    @SideOnly(value=Side.CLIENT)
    private static final IBakedModel[][] chuteModel = new IBakedModel[BlockTypes_MetalsAll.values().length][];
    @SideOnly(value=Side.CLIENT)
    private static final Function<ResourceLocation, TextureAtlasSprite>[] TEXTURE_GETTERS = new Function[BlockTypes_MetalsAll.values().length];
    @SideOnly(value=Side.CLIENT)
    private static boolean initTextures = false;

    private ConveyorChute(int sheetmetalType) {
        this.sheetmetalType = sheetmetalType;
    }

    @Override
    public String getModelCacheKey(TileEntity tile, EnumFacing facing) {
        String key = ConveyorHandler.reverseClassRegistry.get(this.getClass()).toString();
        key = key + "f" + facing.ordinal();
        key = key + "a" + (this.isActive(tile) ? 1 : 0);
        key = key + "c" + this.getDyeColour();
        key = key + "t" + this.sheetmetalType;
        key = key + "d" + this.diagonal;
        key = key + "w";
        for (EnumFacing d : EnumFacing.field_176754_o) {
            key = key + (this.renderWall(tile, d, facing) ? "1" : "0");
        }
        return key;
    }

    @Override
    public EnumFacing[] sigTransportDirections(TileEntity conveyorTile, EnumFacing facing) {
        return new EnumFacing[]{EnumFacing.DOWN, facing};
    }

    @Override
    public void onEntityCollision(TileEntity tile, Entity entity, EnumFacing facing) {
        boolean contact = false;
        if (!this.diagonal) {
            contact = entity.field_70163_u - (double)tile.func_174877_v().func_177956_o() <= 0.125;
        } else if (facing == EnumFacing.NORTH) {
            contact = entity.field_70161_v - (double)tile.func_174877_v().func_177952_p() <= 0.125;
        } else if (facing == EnumFacing.SOUTH) {
            contact = entity.field_70161_v - (double)tile.func_174877_v().func_177952_p() >= 0.875;
        } else if (facing == EnumFacing.WEST) {
            contact = entity.field_70165_t - (double)tile.func_174877_v().func_177958_n() <= 0.125;
        } else if (facing == EnumFacing.EAST) {
            boolean bl = contact = entity.field_70165_t - (double)tile.func_174877_v().func_177958_n() >= 0.875;
        }
        if (this.diagonal && entity.field_70163_u - (double)tile.func_174877_v().func_177956_o() <= 0.625) {
            long time = System.currentTimeMillis();
            String hash = Integer.toHexString(tile.func_174877_v().hashCode());
            if ((double)entity.field_70130_N > 0.75 || (double)entity.field_70131_O > 0.75) {
                double py = entity.field_70131_O > 1.0f ? (double)((float)tile.func_174877_v().func_177956_o() - (entity.field_70131_O - 1.0f)) : entity.field_70163_u;
                entity.func_70107_b(entity.field_70165_t + (double)facing.func_82601_c(), py, entity.field_70161_v + (double)facing.func_82599_e());
            } else {
                if (entity.field_70181_x == 0.0) {
                    entity.field_70181_x = 0.015;
                }
                entity.field_70159_w = facing.func_82601_c();
                entity.field_70179_y = facing.func_82599_e();
            }
            if (!(contact || entity.getEntityData().func_74764_b(NBT_POS) && hash.equals(entity.getEntityData().func_74779_i(NBT_POS)) && time - entity.getEntityData().func_74763_f(NBT_TIME) <= 1000L)) {
                tile.func_145831_w().func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, IESounds.chute, SoundCategory.BLOCKS, 0.6f + 0.4f * tile.func_145831_w().field_73012_v.nextFloat(), 0.5f + 0.5f * tile.func_145831_w().field_73012_v.nextFloat());
                entity.getEntityData().func_74778_a(NBT_POS, hash);
                entity.getEntityData().func_74772_a(NBT_TIME, time);
            }
        }
        if (entity instanceof EntityItem) {
            EntityItem item = (EntityItem)entity;
            item.func_174867_a(10);
            if (!contact) {
                if (item.func_174872_o() > item.lifespan - 1200) {
                    item.func_70288_d();
                }
                ConveyorHandler.applyMagnetSupression(entity, (ConveyorHandler.IConveyorTile)tile);
            } else {
                TileEntity inventoryTile = Utils.getExistingTileEntity(tile.func_145831_w(), this.diagonal ? tile.func_174877_v().func_177972_a(facing) : tile.func_174877_v().func_177977_b());
                if (!(inventoryTile instanceof ConveyorHandler.IConveyorTile)) {
                    ItemStack stack;
                    ConveyorHandler.revertMagnetSupression(entity, (ConveyorHandler.IConveyorTile)tile);
                    if (!tile.func_145831_w().field_72995_K && inventoryTile != null && !(stack = item.func_92059_d()).func_190926_b()) {
                        ItemStack ret = Utils.insertStackIntoInventory(inventoryTile, stack, this.diagonal ? facing.func_176734_d() : EnumFacing.UP);
                        if (ret.func_190926_b()) {
                            entity.func_70106_y();
                        } else if (ret.func_190916_E() < stack.func_190916_E()) {
                            item.func_92058_a(ret);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void onItemDeployed(TileEntity tile, EntityItem entity, EnumFacing facing) {
        entity.func_174867_a(10);
    }

    @Override
    public boolean playerInteraction(TileEntity tile, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ, EnumFacing side) {
        if (Utils.isHammer(heldItem) && player.func_70093_af()) {
            this.diagonal = !this.diagonal;
            return true;
        }
        return false;
    }

    @Override
    public List<AxisAlignedBB> getSelectionBoxes(TileEntity tile, EnumFacing facing) {
        return selectionBoxes;
    }

    @Override
    public List<AxisAlignedBB> getColisionBoxes(TileEntity tile, EnumFacing facing) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        for (EnumFacing f : EnumFacing.field_176754_o) {
            if (this.isInwardConveyor(tile, f) || this.diagonal && f == facing) continue;
            list.add(bounds[f.ordinal() - 2]);
        }
        if (this.diagonal) {
            list.add(conveyorBounds);
        }
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel, @Nullable TileEntity tile, EnumFacing facing) {
        if (!initTextures) {
            for (BlockTypes_MetalsAll metal : BlockTypes_MetalsAll.values()) {
                ConveyorChute.TEXTURE_GETTERS[metal.getMeta()] = rl -> Minecraft.func_71410_x().func_147117_R().func_110572_b("immersiveengineering:blocks/sheetmetal_" + metal.func_176610_l());
            }
            initTextures = true;
        }
        if (this.sheetmetalType < 0 || this.sheetmetalType >= TEXTURE_GETTERS.length) {
            return baseModel;
        }
        Function<ResourceLocation, TextureAtlasSprite> textureGetter = TEXTURE_GETTERS[this.sheetmetalType];
        if (chuteModel[this.sheetmetalType] == null) {
            try {
                IModel iModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("immersiveengineering:block/metal_device/chute.obj"));
                ConveyorChute.chuteModel[this.sheetmetalType] = new IBakedModel[]{iModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"base"), true, (IModelState)ModelRotation.X0_Y180), DefaultVertexFormats.field_176599_b, textureGetter), iModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"base"), true, (IModelState)ModelRotation.X0_Y0), DefaultVertexFormats.field_176599_b, textureGetter), iModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"base"), true, (IModelState)ModelRotation.X0_Y90), DefaultVertexFormats.field_176599_b, textureGetter), iModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"base"), true, (IModelState)ModelRotation.X0_Y270), DefaultVertexFormats.field_176599_b, textureGetter)};
            }
            catch (Exception iModel) {
                // empty catch block
            }
        }
        float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        Matrix4 matrix = new Matrix4(facing);
        baseModel.clear();
        if (this.diagonal) {
            IBlockState bs;
            IBlockState iBlockState = bs = tile != null && tile.func_145831_w() != null ? tile.func_145831_w().func_180495_p(tile.func_174877_v()) : IEContent.blockConveyor.func_176223_P();
            if (chuteModel[this.sheetmetalType] != null && facing.ordinal() >= 2) {
                baseModel.addAll(chuteModel[this.sheetmetalType][facing.ordinal() - 2].func_188616_a(bs, null, 0L));
            }
        } else {
            Function<EnumFacing, TextureAtlasSprite> getSprite = f -> (TextureAtlasSprite)textureGetter.apply(null);
            baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0625f, 1.0f, 0.0625f), matrix, facing, getSprite, colour));
            baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0f, 0.0f, 0.9375f), new Vector3f(0.0625f, 1.0f, 1.0f), matrix, facing, getSprite, colour));
            baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.9375f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0625f), matrix, facing, getSprite, colour));
            baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.9375f, 0.0f, 0.9375f), new Vector3f(1.0f, 1.0f, 1.0f), matrix, facing, getSprite, colour));
            if (this.renderWall(tile, EnumFacing.NORTH, facing)) {
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0625f, 0.0f, 0.0f), new Vector3f(0.9375f, 1.0f, 0.0625f), matrix, facing, getSprite, colour));
            }
            if (this.renderWall(tile, EnumFacing.SOUTH, facing)) {
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0625f, 0.0f, 0.9375f), new Vector3f(0.9375f, 1.0f, 1.0f), matrix, facing, getSprite, colour));
            }
            if (this.renderWall(tile, EnumFacing.WEST, facing)) {
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0f, 0.0f, 0.0625f), new Vector3f(0.0625f, 1.0f, 0.9375f), matrix, facing, getSprite, colour));
            }
            if (this.renderWall(tile, EnumFacing.EAST, facing)) {
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.9375f, 0.0f, 0.0625f), new Vector3f(1.0f, 1.0f, 0.9375f), matrix, facing, getSprite, colour));
            }
        }
        return baseModel;
    }

    private boolean renderWall(@Nullable TileEntity tile, EnumFacing direction, EnumFacing facing) {
        return tile == null || !this.isInwardConveyor(tile, Utils.rotateFacingTowardsDir(direction, facing));
    }

    @Override
    public NBTTagCompound writeConveyorNBT() {
        NBTTagCompound nbt = super.writeConveyorNBT();
        nbt.func_74768_a("sheetmetalType", this.sheetmetalType);
        nbt.func_74757_a("diagonal", this.diagonal);
        return nbt;
    }

    @Override
    public void readConveyorNBT(NBTTagCompound nbt) {
        super.readConveyorNBT(nbt);
        this.sheetmetalType = nbt.func_74762_e("sheetmetalType");
        this.diagonal = nbt.func_74767_n("diagonal");
    }

    public static class ConveyorChuteCopper
    extends ConveyorChute {
        public ConveyorChuteCopper() {
            super(BlockTypes_MetalsAll.COPPER.getMeta());
        }
    }

    public static class ConveyorChuteAluminum
    extends ConveyorChute {
        public ConveyorChuteAluminum() {
            super(BlockTypes_MetalsAll.ALUMINUM.getMeta());
        }
    }

    public static class ConveyorChuteSteel
    extends ConveyorChute {
        public ConveyorChuteSteel() {
            super(BlockTypes_MetalsAll.STEEL.getMeta());
        }
    }

    public static class ConveyorChuteIron
    extends ConveyorChute {
        public ConveyorChuteIron() {
            super(BlockTypes_MetalsAll.IRON.getMeta());
        }
    }
}

