/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.item.IItemElectricBase;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachine;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachineTiered;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;

public class TileEntityEnergyStorageModule
extends TileBaseUniversalElectricalSource
implements ISidedInventory,
IInventoryDefaults,
IConnector,
IMachineSides {
    private static final float BASE_CAPACITY = 500000.0f;
    private static final float TIER2_CAPACITY = 2500000.0f;
    public final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    public int scaledEnergyLevel;
    public int lastScaledEnergyLevel;
    private float lastEnergy = 0.0f;
    private boolean initialised = true;
    private IMachineSides.MachineSidePack[] machineSides;

    public TileEntityEnergyStorageModule() {
        this(1);
    }

    public TileEntityEnergyStorageModule(int tier) {
        super(tier == 1 ? "tile.machine.1.name" : "tile.machine.8.name");
        this.inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        if (tier == 1) {
            this.storage.setCapacity(500000.0f);
            this.storage.setMaxExtract(300.0f);
            return;
        }
        this.setTier2();
    }

    private void setTier2() {
        this.storage.setCapacity(2500000.0f);
        this.storage.setMaxExtract(1800.0f);
        this.setTierGC(2);
    }

    @Override
    public void func_73660_a() {
        if (!this.initialised) {
            int metadata = this.func_145832_p();
            Block b = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c();
            if (b == GCBlocks.machineBase) {
                this.field_145850_b.func_180501_a(this.func_174877_v(), GCBlocks.machineTiered.func_176223_P(), 2);
            } else if (metadata >= 8) {
                this.setTier2();
            }
            this.initialised = true;
        }
        float energy = this.storage.getEnergyStoredGC();
        if (this.getTierGC() == 1 && !this.field_145850_b.field_72995_K && this.lastEnergy - energy > this.storage.getMaxExtract() - 1.0f) {
            this.storage.extractEnergyGC(25.0f, false);
        }
        this.lastEnergy = energy;
        super.func_73660_a();
        this.scaledEnergyLevel = (int)Math.floor((this.getEnergyStoredGC() + 49.0f) * 16.0f / this.getMaxEnergyStoredGC());
        if (this.scaledEnergyLevel != this.lastScaledEnergyLevel) {
            this.field_145850_b.func_175679_n(this.func_174877_v());
        }
        if (!this.field_145850_b.field_72995_K) {
            this.recharge((ItemStack)this.getInventory().get(0));
            this.discharge((ItemStack)this.getInventory().get(1));
        }
        if (!this.field_145850_b.field_72995_K) {
            this.produce();
        }
        this.lastScaledEnergyLevel = this.scaledEnergyLevel;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.storage.getEnergyStoredGC() > 500000.0f) {
            this.setTier2();
            this.initialised = true;
        } else {
            this.initialised = false;
        }
        this.readMachineSidesFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.tierGC == 1 && this.storage.getEnergyStoredGC() > 500000.0f) {
            this.storage.setEnergyStored(500000.0f);
        }
        super.func_189515_b(nbt);
        this.addMachineSidesToNBT(nbt);
        return nbt;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return ItemElectricBase.isElectricItem(itemstack.func_77973_b());
    }

    @Override
    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        if (itemstack.func_77973_b() instanceof IItemElectricBase) {
            if (slotID == 0) {
                return ((IItemElectricBase)itemstack.func_77973_b()).getTransfer(itemstack) > 0.0f;
            }
            if (slotID == 1) {
                return ((IItemElectricBase)itemstack.func_77973_b()).getElectricityStored(itemstack) > 0.0f;
            }
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (itemstack.func_77973_b() instanceof IItemElectricBase) {
            if (slotID == 0) {
                return ((IItemElectricBase)itemstack.func_77973_b()).getTransfer(itemstack) <= 0.0f;
            }
            if (slotID == 1) {
                return ((IItemElectricBase)itemstack.func_77973_b()).getElectricityStored(itemstack) <= 0.0f || this.getEnergyStoredGC() >= this.getMaxEnergyStoredGC();
            }
        }
        return false;
    }

    @Override
    public EnumSet<EnumFacing> getElectricalInputDirections() {
        return EnumSet.of(this.getElectricInputDirection());
    }

    @Override
    public EnumSet<EnumFacing> getElectricalOutputDirections() {
        return EnumSet.of(this.getElectricOutputDirection());
    }

    @Override
    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null || type != NetworkType.POWER) {
            return false;
        }
        return this.getElectricalInputDirections().contains(direction) || this.getElectricalOutputDirections().contains(direction);
    }

    @Override
    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockMachineTiered) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockMachineTiered.FACING);
        }
        if (state.func_177230_c() instanceof BlockMachine) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockMachine.FACING);
        }
        return EnumFacing.NORTH;
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        switch (this.getSide(IMachineSides.MachineSide.ELECTRIC_IN)) {
            case LEFT: {
                return this.getFront().func_176746_e();
            }
            case REAR: {
                return this.getFront().func_176734_d();
            }
            case TOP: {
                return EnumFacing.UP;
            }
            case BOTTOM: {
                return EnumFacing.DOWN;
            }
        }
        return this.getFront().func_176735_f();
    }

    @Override
    public EnumFacing getElectricOutputDirection() {
        switch (this.getSide(IMachineSides.MachineSide.ELECTRIC_OUT)) {
            case RIGHT: {
                return this.getFront().func_176735_f();
            }
            case REAR: {
                return this.getFront().func_176734_d();
            }
            case TOP: {
                return EnumFacing.UP;
            }
            case BOTTOM: {
                return EnumFacing.DOWN;
            }
        }
        return this.getFront().func_176746_e();
    }

    @Override
    public IMachineSides.MachineSide[] listConfigurableSides() {
        return new IMachineSides.MachineSide[]{IMachineSides.MachineSide.ELECTRIC_IN, IMachineSides.MachineSide.ELECTRIC_OUT};
    }

    @Override
    public IMachineSides.Face[] listDefaultFaces() {
        return new IMachineSides.Face[]{IMachineSides.Face.RIGHT, IMachineSides.Face.LEFT};
    }

    @Override
    public synchronized IMachineSides.MachineSidePack[] getAllMachineSides() {
        if (this.machineSides == null) {
            this.initialiseSides();
        }
        return this.machineSides;
    }

    @Override
    public void setupMachineSides(int length) {
        this.machineSides = new IMachineSides.MachineSidePack[length];
    }

    public void onLoad() {
        this.clientOnLoad();
    }

    @Override
    public IMachineSidesProperties getConfigurationType() {
        return BlockMachineTiered.MACHINESIDES_RENDERTYPE;
    }
}

