/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.client.gui.machines;

import com.mjr.extraplanets.inventory.machines.ContainerSolar;
import com.mjr.extraplanets.tileEntities.machines.TileEntitySolar;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiSolar
extends GuiContainerGC {
    private static final ResourceLocation solarGuiTexture = new ResourceLocation("galacticraftcore", "textures/gui/solar.png");
    private final TileEntitySolar tileEntity;
    private GuiButton buttonEnableSolar;
    private GuiElementInfoRegion electricInfoRegion;

    public GuiSolar(InventoryPlayer inventoryPlayer, TileEntitySolar tileEntity) {
        super((Container)new ContainerSolar(inventoryPlayer, tileEntity));
        this.electricInfoRegion = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 107, (this.field_146295_m - this.field_147000_g) / 2 + 101, 56, 9, new ArrayList(), this.field_146294_l, this.field_146295_m, (GuiContainerGC)this);
        this.tileEntity = tileEntity;
        this.field_147000_g = 201;
        this.field_146999_f = 176;
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        switch (par1GuiButton.field_146127_k) {
            case 0: {
                GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, this.field_146297_k.field_71441_e.field_73011_w.func_186058_p().func_186068_a(), new Object[]{this.tileEntity.func_174877_v(), 0}));
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(TranslateUtilities.translate((String)"gui.energy_storage.desc.0"));
        electricityDesc.add(EnumColor.YELLOW + TranslateUtilities.translate((String)"gui.energy_storage.desc.1") + (int)Math.floor(this.tileEntity.getEnergyStoredGC()) + " / " + (int)Math.floor(this.tileEntity.getMaxEnergyStoredGC()));
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        this.electricInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 96;
        this.electricInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 24;
        this.electricInfoRegion.parentWidth = this.field_146294_l;
        this.electricInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.electricInfoRegion);
        ArrayList<String> batterySlotDesc = new ArrayList<String>();
        batterySlotDesc.add(TranslateUtilities.translate((String)"gui.battery_slot.desc.0"));
        batterySlotDesc.add(TranslateUtilities.translate((String)"gui.battery_slot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 151, (this.field_146295_m - this.field_147000_g) / 2 + 82, 18, 18, batterySlotDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this));
        ArrayList<String> sunGenDesc = new ArrayList<String>();
        float sunVisible = (float)Math.round((float)this.tileEntity.solarStrength / 9.0f * 1000.0f) / 10.0f;
        sunGenDesc.add(this.tileEntity.solarStrength > 0 ? TranslateUtilities.translate((String)"gui.status.sun_visible.name") + ": " + sunVisible + "%" : TranslateUtilities.translate((String)"gui.status.blockedfully.name"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 47, (this.field_146295_m - this.field_147000_g) / 2 + 20, 18, 18, sunGenDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this));
        this.buttonEnableSolar = new GuiButton(0, this.field_146294_l / 2 - 36, this.field_146295_m / 2 - 19, 72, 20, TranslateUtilities.translate((String)"gui.button.enable.name"));
        this.field_146292_n.add(this.buttonEnableSolar);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int offsetY = 35;
        this.buttonEnableSolar.field_146124_l = this.tileEntity.disableCooldown == 0;
        this.buttonEnableSolar.field_146126_j = !this.tileEntity.getDisabled(0) ? TranslateUtilities.translate((String)"gui.button.disable.name") : TranslateUtilities.translate((String)"gui.button.enable.name");
        String displayString = this.tileEntity.func_70005_c_();
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 7, 0x404040);
        displayString = TranslateUtilities.translate((String)"gui.message.status.name") + ": " + this.getStatus();
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 22 + offsetY, 0x404040);
        displayString = TranslateUtilities.translate((String)"gui.message.generating.name") + ": " + (this.tileEntity.generateWatts > 0 ? EnergyDisplayHelper.getEnergyDisplayS((float)this.tileEntity.generateWatts) + "/t" : TranslateUtilities.translate((String)"gui.status.not_generating.name"));
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 11 + offsetY, 0x404040);
        float boost = (float)Math.round((this.tileEntity.getSolarBoost() - 1.0f) * 1000.0f) / 10.0f;
        displayString = TranslateUtilities.translate((String)"gui.message.environment.name") + ": " + boost + "%";
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 33 + offsetY, 0x404040);
        this.field_146289_q.func_78276_b(TranslateUtilities.translate((String)"container.inventory"), 8, this.field_147000_g - 94, 0x404040);
    }

    private String getStatus() {
        if (this.tileEntity.getDisabled(0)) {
            return EnumColor.ORANGE + TranslateUtilities.translate((String)"gui.status.disabled.name");
        }
        if (!this.tileEntity.func_145831_w().func_72935_r()) {
            return EnumColor.DARK_RED + TranslateUtilities.translate((String)"gui.status.blockedfully.name");
        }
        if (this.tileEntity.func_145831_w().func_72896_J() || this.tileEntity.func_145831_w().func_72911_I()) {
            return EnumColor.DARK_RED + TranslateUtilities.translate((String)"gui.status.raining.name");
        }
        if (this.tileEntity.solarStrength == 0) {
            return EnumColor.DARK_RED + TranslateUtilities.translate((String)"gui.status.blockedfully.name");
        }
        if (this.tileEntity.solarStrength < 9) {
            return EnumColor.DARK_RED + TranslateUtilities.translate((String)"gui.status.blockedpartial.name");
        }
        if (this.tileEntity.generateWatts > 0) {
            return EnumColor.DARK_GREEN + TranslateUtilities.translate((String)"gui.status.collectingenergy.name");
        }
        return EnumColor.ORANGE + TranslateUtilities.translate((String)"gui.status.unknown.name");
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(solarGuiTexture);
        int var5 = (this.field_146294_l - this.field_146999_f) / 2;
        int var6 = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(var5, var6, 0, 0, this.field_146999_f, this.field_147000_g);
        ArrayList electricityDesc = new ArrayList();
        EnergyDisplayHelper.getEnergyDisplayTooltip((float)this.tileEntity.getEnergyStoredGC(), (float)this.tileEntity.getMaxEnergyStoredGC(), electricityDesc);
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        if (this.tileEntity.getEnergyStoredGC() > 0.0f) {
            this.func_73729_b(var5 + 83, var6 + 24, 176, 0, 11, 10);
        }
        if (this.tileEntity.isDaylight) {
            this.func_73729_b(var5 + 48, var6 + 21, 176, 10, 16, 16);
        }
        this.func_73729_b(var5 + 97, var6 + 25, 187, 0, Math.min(this.tileEntity.getScaledElecticalLevel(54), 54), 7);
    }
}

