/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.blocks;

import com.mjr.extraplanets.blocks.BlockCakeBlocks;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.blocks.fluid.ExtraPlanets_Fluids;
import com.mjr.extraplanets.items.ExtraPlanets_Items;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWhiteSugerCane
extends Block
implements IPlantable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)15);
    protected static final AxisAlignedBB REED_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    protected BlockWhiteSugerCane(String name) {
        super(Material.field_151585_k);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149663_c(name);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return REED_AABB;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if ((world.func_180495_p(pos.func_177977_b()).func_177230_c() == ExtraPlanets_Blocks.WHITE_SUGAR_CANE || this.checkForDrop(world, pos, state)) && world.func_175623_d(pos.func_177984_a())) {
            int i = 1;
            while (world.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
                ++i;
            }
            if (i < 3) {
                int j = (Integer)state.func_177229_b((IProperty)AGE);
                if (ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (boolean)true)) {
                    if (j == 15) {
                        world.func_175656_a(pos.func_177984_a(), this.func_176223_P());
                        world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)), 4);
                    } else {
                        world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                    }
                    ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)state, (IBlockState)world.func_180495_p(pos));
                }
            }
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        Block block = state.func_177230_c();
        if (block.canSustainPlant(state, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this)) {
            return true;
        }
        if (block == this) {
            return true;
        }
        if (state != ExtraPlanets_Blocks.CAKE_BLOCKS.func_176223_P().func_177226_a(BlockCakeBlocks.BASIC_TYPE, (Comparable)((Object)BlockCakeBlocks.EnumBlockBasic.CAKE_BLOCK))) {
            return false;
        }
        BlockPos blockpos = pos.func_177977_b();
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate = world.func_180495_p(blockpos.func_177972_a(enumfacing));
            if (iblockstate.func_185904_a() != ExtraPlanets_Fluids.CHOCOLATE_MATERIAL) continue;
            return true;
        }
        return false;
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block block) {
        this.checkForDrop(world, pos, state);
    }

    protected final boolean checkForDrop(World world, BlockPos pos, IBlockState state) {
        if (this.canBlockStay(world, pos)) {
            return true;
        }
        this.func_176226_b(world, pos, state, 0);
        world.func_175698_g(pos);
        return false;
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        return this.func_176196_c(world, pos);
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState state, World world, BlockPos pos) {
        return field_185506_k;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(ExtraPlanets_Items.WHITE_SUGAR_CANE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Beach;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.func_176223_P();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }
}

