/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.xml;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;
import org.cyclops.cyclopscore.recipe.xml.DefaultItemTypeHandler;
import org.cyclops.cyclopscore.recipe.xml.IItemTypeHandler;
import org.cyclops.cyclopscore.recipe.xml.IRecipeTypeHandler;
import org.cyclops.cyclopscore.recipe.xml.OreDictItemTypeHandler;
import org.cyclops.cyclopscore.recipe.xml.PredefinedItemTypeHandler;
import org.cyclops.cyclopscore.recipe.xml.XmlRecipeLoader;
import org.w3c.dom.Node;

public abstract class CommonRecipeTypeHandler<I extends IRecipeInput, O extends IRecipeOutput, P extends IRecipeProperties>
implements IRecipeTypeHandler<I, O, P>,
IItemTypeHandler {
    private static final Map<String, IItemTypeHandler> ITEM_TYPE_HANDLERS = Maps.newHashMap();
    protected static final String DEFAULT_ITEM_TYPE = "default";

    public static void registerItemTypeHandler(String type, IItemTypeHandler handler) {
        ITEM_TYPE_HANDLERS.put(type, handler);
    }

    @Override
    public Ingredient getIngredient(RecipeHandler recipeHandler, Node itemNode) throws XmlRecipeLoader.XmlRecipeException {
        String type = DEFAULT_ITEM_TYPE;
        Node typeAttribute = itemNode.getAttributes().getNamedItem("type");
        if (typeAttribute != null) {
            type = typeAttribute.getTextContent();
        }
        return this.getItem(recipeHandler, itemNode, type);
    }

    protected Ingredient getItem(RecipeHandler recipeHandler, Node itemNode, String type) throws XmlRecipeLoader.XmlRecipeException {
        IItemTypeHandler handler = ITEM_TYPE_HANDLERS.get(type);
        if (handler == null) {
            throw new XmlRecipeLoader.XmlRecipeException(String.format("Could not find an item type handler of type '%s'", type));
        }
        return handler.getIngredient(recipeHandler, itemNode);
    }

    protected FluidStack getFluid(RecipeHandler recipeHandler, Node fluidNode) throws XmlRecipeLoader.XmlRecipeException {
        String fluidName;
        Fluid fluid;
        int amount = 1000;
        Node amountNode = fluidNode.getAttributes().getNamedItem("amount");
        if (amountNode != null) {
            amount = Integer.parseInt(amountNode.getTextContent());
        }
        if ((fluid = FluidRegistry.getFluid((String)(fluidName = fluidNode.getTextContent()))) == null) {
            throw new XmlRecipeLoader.XmlRecipeException(String.format("Fluid by name '%s' has not been found.", fluidName));
        }
        return new FluidStack(fluid, amount);
    }

    protected float getChance(RecipeHandler recipeHandler, Node ingredientNode) throws XmlRecipeLoader.XmlRecipeException {
        float chance = 1.0f;
        Node chanceNode = ingredientNode.getAttributes().getNamedItem("chance");
        if (chanceNode != null) {
            chance = Float.parseFloat(chanceNode.getTextContent());
        }
        return chance;
    }

    static {
        ITEM_TYPE_HANDLERS.put(DEFAULT_ITEM_TYPE, new DefaultItemTypeHandler());
        ITEM_TYPE_HANDLERS.put("oredict", new OreDictItemTypeHandler());
        ITEM_TYPE_HANDLERS.put("predefined", new PredefinedItemTypeHandler());
    }
}

