/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.storage;

import java.util.Iterator;
import javax.annotation.Nonnull;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageSlotted;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientListMutable;

public class IngredientComponentStorageSlottedCollectionWrapper<T, M>
implements IIngredientComponentStorageSlotted<T, M> {
    private final IIngredientListMutable<T, M> ingredientCollection;
    private final long maxSlotQuantity;
    private final long rateLimit;
    private long quantity;

    public IngredientComponentStorageSlottedCollectionWrapper(IIngredientListMutable<T, M> ingredientCollection, long maxSlotQuantity, long rateLimit) {
        this.ingredientCollection = ingredientCollection;
        this.maxSlotQuantity = maxSlotQuantity;
        this.rateLimit = rateLimit;
        this.quantity = 0L;
    }

    public int getSlots() {
        return this.ingredientCollection.size();
    }

    public T getSlotContents(int slot) {
        return this.ingredientCollection.get(slot);
    }

    public long getMaxQuantity(int slot) {
        return this.maxSlotQuantity;
    }

    T rateLimit(T instance, long allowedQuantity) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        long quantity = matcher.getQuantity(instance);
        long actualQuantity = Math.min(quantity, Math.min(allowedQuantity, this.rateLimit));
        if (actualQuantity == quantity) {
            return instance;
        }
        return (T)matcher.withQuantity(instance, actualQuantity);
    }

    public T insert(int slot, @Nonnull T ingredient, boolean simulate) {
        Object contained;
        T insertingIngredient = this.rateLimit(ingredient, this.getMaxQuantity() - this.quantity);
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        if (!matcher.isEmpty(insertingIngredient) && (matcher.isEmpty(contained = this.ingredientCollection.get(slot)) || matcher.matches(ingredient, contained, matcher.getExactMatchNoQuantityCondition()))) {
            long addQuantity = Math.min(this.getMaxQuantity(slot) - matcher.getQuantity(contained), matcher.getQuantity(insertingIngredient));
            if (!simulate) {
                this.ingredientCollection.set(slot, matcher.withQuantity(ingredient, matcher.getQuantity(contained) + addQuantity));
                this.quantity += addQuantity;
            }
            return (T)matcher.withQuantity(insertingIngredient, matcher.getQuantity(ingredient) - addQuantity);
        }
        return ingredient;
    }

    public T extract(int slot, long maxQuantity, boolean simulate) {
        Object contained;
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        if (!matcher.isEmpty(contained = this.ingredientCollection.get(slot))) {
            Object extractingIngredient = this.rateLimit(contained, maxQuantity);
            if (!simulate) {
                long removeQuantity = matcher.getQuantity(extractingIngredient);
                this.ingredientCollection.set(slot, matcher.withQuantity(contained, matcher.getQuantity(contained) - removeQuantity));
                this.quantity -= removeQuantity;
            }
            return extractingIngredient;
        }
        return (T)matcher.getEmptyInstance();
    }

    public IngredientComponent<T, M> getComponent() {
        return this.ingredientCollection.getComponent();
    }

    public Iterator<T> iterator() {
        return this.ingredientCollection.iterator();
    }

    public Iterator<T> iterator(@Nonnull T prototype, M matchCondition) {
        return this.ingredientCollection.iterator(prototype, matchCondition);
    }

    public long getMaxQuantity() {
        return (long)this.getSlots() * this.maxSlotQuantity;
    }

    public T insert(@Nonnull T ingredient, boolean simulate) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        long givenQuantity = matcher.getQuantity(ingredient);
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            T insertRemaining = this.insert(slot, ingredient, true);
            if (matcher.getQuantity(insertRemaining) == givenQuantity) continue;
            return simulate ? insertRemaining : this.insert(slot, ingredient, false);
        }
        return ingredient;
    }

    public T extract(@Nonnull T prototype, M matchCondition, boolean simulate) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            Object extractingIngredient;
            Object contained = this.ingredientCollection.get(slot);
            if (matcher.isEmpty(contained) || !matcher.matches(contained, prototype, matchCondition) || !matcher.matches(prototype, extractingIngredient = this.rateLimit(contained, matcher.getQuantity(prototype)), matchCondition)) continue;
            if (!simulate) {
                long removeQuantity = matcher.getQuantity(extractingIngredient);
                this.ingredientCollection.set(slot, matcher.withQuantity(contained, matcher.getQuantity(contained) - removeQuantity));
                this.quantity -= removeQuantity;
            }
            return extractingIngredient;
        }
        return (T)matcher.getEmptyInstance();
    }

    public T extract(long maxQuantity, boolean simulate) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            int extracted = this.extract((T)slot, (M)maxQuantity, true);
            if (matcher.isEmpty((Object)extracted)) continue;
            return simulate ? extracted : this.extract((T)slot, (M)maxQuantity, false);
        }
        return (T)matcher.getEmptyInstance();
    }
}

