/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.reference;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.computronics.api.audio.AudioPacket;
import pl.asie.computronics.api.audio.IAudioReceiver;
import pl.asie.computronics.api.audio.IAudioSource;
import pl.asie.computronics.audio.AudioUtils;

public class Capabilities {
    public static final Capabilities INSTANCE = new Capabilities();
    @CapabilityInject(value=IAudioSource.class)
    public static Capability<IAudioSource> AUDIO_SOURCE_CAPABILITY;
    @CapabilityInject(value=IAudioReceiver.class)
    public static Capability<IAudioReceiver> AUDIO_RECEIVER_CAPABILITY;
    private static final ResourceLocation AUDIO_SOURCE_KEY;
    private static final ResourceLocation AUDIO_RECEIVER_KEY;

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        CapabilityManager.INSTANCE.register(IAudioSource.class, new NullCapabilityStorage(), DefaultAudioSource.class);
        CapabilityManager.INSTANCE.register(IAudioReceiver.class, new NullCapabilityStorage(), DefaultAudioReceiver.class);
    }

    public static boolean hasAny(@Nullable ICapabilityProvider provider, EnumFacing dir, Capability ... caps) {
        if (provider == null) {
            return false;
        }
        for (Capability cap : caps) {
            if (!provider.hasCapability(cap, dir)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAll(@Nullable ICapabilityProvider provider, EnumFacing dir, Capability ... caps) {
        if (provider == null) {
            return false;
        }
        for (Capability cap : caps) {
            if (provider.hasCapability(cap, dir)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static <T> T getFirst(@Nullable ICapabilityProvider provider, EnumFacing dir, Iterable<Capability<? extends T>> caps) {
        if (provider == null) {
            return null;
        }
        for (Capability<T> capability : caps) {
            if (!provider.hasCapability(capability, dir)) continue;
            return (T)provider.getCapability(capability, dir);
        }
        return null;
    }

    @Nullable
    public static <T> T getFirst(@Nullable ICapabilityProvider provider, EnumFacing dir, Capability<? extends T> first, Capability<? extends T> second) {
        if (provider == null) {
            return null;
        }
        if (provider.hasCapability(first, dir)) {
            return (T)provider.getCapability(first, dir);
        }
        if (provider.hasCapability(second, dir)) {
            return (T)provider.getCapability(second, dir);
        }
        return null;
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<TileEntity> e) {
        final TileEntity tile = (TileEntity)e.getObject();
        if (tile instanceof IAudioSource) {
            e.addCapability(AUDIO_SOURCE_KEY, new ICapabilityProvider(){

                public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == AUDIO_SOURCE_CAPABILITY;
                }

                @Nullable
                public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                    return (T)(this.hasCapability(capability, facing) ? AUDIO_SOURCE_CAPABILITY.cast((Object)((IAudioSource)tile)) : null);
                }
            });
        }
        if (tile instanceof IAudioReceiver) {
            e.addCapability(AUDIO_RECEIVER_KEY, new ICapabilityProvider(){

                public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == AUDIO_RECEIVER_CAPABILITY;
                }

                @Nullable
                public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                    return (T)(this.hasCapability(capability, facing) ? AUDIO_RECEIVER_CAPABILITY.cast((Object)((IAudioReceiver)tile)) : null);
                }
            });
        }
    }

    private Capabilities() {
    }

    static {
        AUDIO_SOURCE_KEY = new ResourceLocation("computronics:audio_source");
        AUDIO_RECEIVER_KEY = new ResourceLocation("computronics:audio_receiver");
    }

    private static class DefaultAudioReceiver
    implements IAudioReceiver {
        private DefaultAudioReceiver() {
        }

        @Override
        @Nullable
        public World getSoundWorld() {
            return null;
        }

        @Override
        public Vec3d getSoundPos() {
            return new Vec3d(0.0, 0.0, 0.0);
        }

        @Override
        public int getSoundDistance() {
            return 0;
        }

        @Override
        public void receivePacket(AudioPacket packet, @Nullable EnumFacing side) {
        }

        @Override
        public String getID() {
            return AudioUtils.positionId(0, 0, 0);
        }

        @Override
        public boolean connectsAudio(EnumFacing side) {
            return false;
        }
    }

    private static class DefaultAudioSource
    implements IAudioSource {
        private DefaultAudioSource() {
        }

        @Override
        public int getSourceId() {
            return -1;
        }

        @Override
        public boolean connectsAudio(EnumFacing side) {
            return false;
        }
    }

    public static class NullCapabilityStorage<T>
    implements Capability.IStorage<T> {
        @Nullable
        public NBTBase writeNBT(Capability<T> capability, T instance, EnumFacing side) {
            return null;
        }

        public void readNBT(Capability<T> capability, T instance, EnumFacing side, NBTBase nbt) {
        }
    }
}

