/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft;

import java.io.IOException;
import mods.railcraft.api.core.IVariantEnum;
import mods.railcraft.client.render.tesr.TESRSignalBox;
import mods.railcraft.common.blocks.IVariantEnumBlock;
import mods.railcraft.common.blocks.machine.BlockMachine;
import mods.railcraft.common.blocks.machine.ItemMachine;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.integration.railcraft.LocomotiveManager;
import pl.asie.computronics.integration.railcraft.SignalTypes;
import pl.asie.computronics.integration.railcraft.block.BlockDigitalDetector;
import pl.asie.computronics.integration.railcraft.block.BlockDigitalSignalBox;
import pl.asie.computronics.integration.railcraft.block.BlockLocomotiveRelay;
import pl.asie.computronics.integration.railcraft.block.BlockTicketMachine;
import pl.asie.computronics.integration.railcraft.gui.GuiProviderTicketMachine;
import pl.asie.computronics.integration.railcraft.item.ItemRelaySensor;
import pl.asie.computronics.integration.railcraft.tile.TileDigitalControllerBox;
import pl.asie.computronics.integration.railcraft.tile.TileDigitalDetector;
import pl.asie.computronics.integration.railcraft.tile.TileDigitalReceiverBox;
import pl.asie.computronics.integration.railcraft.tile.TileLocomotiveRelay;
import pl.asie.computronics.integration.railcraft.tile.TileTicketMachine;
import pl.asie.lib.network.Packet;

public class IntegrationRailcraft {
    public BlockLocomotiveRelay locomotiveRelay;
    public BlockDigitalDetector detector;
    public ItemRelaySensor relaySensor;
    public BlockDigitalSignalBox digitalBox;
    public ItemMachine digitalBoxItem;
    public BlockTicketMachine ticketMachine;
    LocomotiveManager manager;
    public GuiProviderTicketMachine guiTicketMachine;

    private static boolean isEnabled(Configuration config, String name, boolean def) {
        return config.get("enable.railcraft", name, def).getBoolean(def);
    }

    public void preInit(Configuration config) {
        if (IntegrationRailcraft.isEnabled(config, "locomotiveRelay", true)) {
            this.locomotiveRelay = new BlockLocomotiveRelay();
            Computronics.instance.registerBlockWithTileEntity(this.locomotiveRelay, TileLocomotiveRelay.class, "locomotive_relay");
            this.relaySensor = new ItemRelaySensor();
            Computronics.instance.registerItem(this.relaySensor, "relay_sensor");
            this.manager = new LocomotiveManager();
            MinecraftForge.EVENT_BUS.register((Object)this.manager);
        }
        SignalTypes.DigitalReceiver.enabled = IntegrationRailcraft.isEnabled(config, "digitalReceiverBox", true);
        SignalTypes.DigitalController.enabled = IntegrationRailcraft.isEnabled(config, "digitalControllerBox", true);
        this.digitalBox = new BlockDigitalSignalBox();
        GameRegistry.findRegistry(Block.class).register(this.digitalBox.setRegistryName(new ResourceLocation("computronics", "digital_box")));
        this.digitalBoxItem = new ItemMachine((BlockMachine)this.digitalBox){

            public String func_77658_a() {
                return ((BlockMachine)this.field_150939_a).func_149739_a();
            }

            public String func_77667_c(ItemStack stack) {
                IVariantEnum variant = this.getVariant(stack);
                if (variant == null) {
                    return this.func_77658_a();
                }
                if (variant instanceof IVariantEnumBlock) {
                    return ((IVariantEnumBlock)variant).getLocalizationTag();
                }
                return "tile.computronics." + variant.getResourcePathSuffix();
            }
        };
        this.digitalBoxItem.setRegistryName(this.digitalBox.getRegistryName());
        GameRegistry.findRegistry(Item.class).register((IForgeRegistryEntry)this.digitalBoxItem);
        TileEntity.func_190560_a((String)"digital_controller_box", TileDigitalControllerBox.class);
        TileEntity.func_190560_a((String)"digital_receiver_box", TileDigitalReceiverBox.class);
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileDigitalControllerBox.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileDigitalReceiverBox.class.getCanonicalName());
        if (IntegrationRailcraft.isEnabled(config, "digitalDetector", true)) {
            this.detector = new BlockDigitalDetector();
            Computronics.instance.registerBlockWithTileEntity(this.detector, TileDigitalDetector.class, "digital_detector");
        }
        if (IntegrationRailcraft.isEnabled(config, "ticketMachine", true)) {
            this.guiTicketMachine = new GuiProviderTicketMachine();
            Computronics.gui.registerGuiProvider(this.guiTicketMachine);
            this.ticketMachine = new BlockTicketMachine();
            Computronics.instance.registerBlockWithTileEntity(this.ticketMachine, TileTicketMachine.class, "ticket_machine");
        }
    }

    @Optional.Method(modid="railcraft")
    public void onMessageRailcraft(Packet packet, EntityPlayer player, boolean isServer) throws IOException {
        TileEntity entity;
        TileEntity tileEntity = entity = isServer ? packet.readTileEntityServer() : packet.readTileEntity();
        if (entity instanceof TileTicketMachine) {
            TileTicketMachine machine = (TileTicketMachine)entity;
            int i = packet.readInt();
            machine.setLocked((i & 1) == 1, isServer);
            machine.setSelectionLocked((i >> 1 & 1) == 1, isServer);
            machine.setPrintLocked((i >> 2 & 1) == 1, isServer);
            machine.setActive((i >> 3 & 1) == 1, isServer);
            machine.setSelectedSlot(packet.readInt(), isServer);
        }
    }

    @Optional.Method(modid="railcraft")
    public void printTicket(Packet packet, EntityPlayer player, boolean isServer) throws IOException {
        TileEntity entity;
        TileEntity tileEntity = entity = isServer ? packet.readTileEntityServer() : packet.readTileEntity();
        if (entity instanceof TileTicketMachine) {
            ((TileTicketMachine)entity).printTicket();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="railcraft")
    public void registerRenderers() {
        this.digitalBox.initializeClient();
        for (SignalTypes type : SignalTypes.VALUES) {
            ItemStack stack = this.digitalBox.getStack((IVariantEnum)type);
            if (stack == null) continue;
            this.digitalBox.registerItemModel(stack, (IVariantEnum)type);
        }
        this.digitalBoxItem.initializeClient();
        ClientRegistry.bindTileEntitySpecialRenderer(TileDigitalReceiverBox.class, (TileEntitySpecialRenderer)new TESRSignalBox());
        ClientRegistry.bindTileEntitySpecialRenderer(TileDigitalControllerBox.class, (TileEntitySpecialRenderer)new TESRSignalBox());
        ModelBakery.registerItemVariants((Item)this.relaySensor, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("computronics:relay_sensor_off")});
        ModelBakery.registerItemVariants((Item)this.relaySensor, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("computronics:relay_sensor_on")});
        ModelLoader.setCustomMeshDefinition((Item)this.relaySensor, (ItemMeshDefinition)new ItemRelaySensor.MeshDefinition());
    }
}

