/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.enderio;

import crazypants.enderio.base.xp.IHaveExperience;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pl.asie.computronics.integration.CCMultiPeripheral;
import pl.asie.computronics.integration.DriverSpecificTileEntity;
import pl.asie.computronics.integration.NamedManagedEnvironment;

public class DriverHasExperience {

    public static class CCDriver
    extends CCMultiPeripheral<IHaveExperience> {
        public CCDriver() {
        }

        public CCDriver(IHaveExperience tile, World world, BlockPos pos) {
            super(tile, "experience_tile", world, pos);
        }

        @Override
        public int peripheralPriority() {
            return 3;
        }

        @Override
        public CCMultiPeripheral getPeripheral(World world, BlockPos pos, EnumFacing side) {
            TileEntity te = world.func_175625_s(pos);
            if (te != null && te instanceof IHaveExperience) {
                return new CCDriver((IHaveExperience)te, world, pos);
            }
            return null;
        }

        public String[] getMethodNames() {
            return new String[]{"getExperience", "getExperienceLevels", "getMaxExperience"};
        }

        public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
            switch (method) {
                case 0: {
                    return new Object[]{((IHaveExperience)this.tile).getContainer().getExperienceTotal()};
                }
                case 1: {
                    return new Object[]{((IHaveExperience)this.tile).getContainer().getExperienceLevel()};
                }
                case 2: {
                    return new Object[]{((IHaveExperience)this.tile).getContainer().getMaximumExperiance()};
                }
            }
            return new Object[0];
        }
    }

    public static class OCDriver
    extends DriverSpecificTileEntity<IHaveExperience> {
        public OCDriver() {
            super(IHaveExperience.class);
        }

        public InternalManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side, IHaveExperience tile) {
            return new InternalManagedEnvironment(tile);
        }

        public static class InternalManagedEnvironment
        extends NamedManagedEnvironment<IHaveExperience> {
            public InternalManagedEnvironment(IHaveExperience tile) {
                super(tile, "experience_tile");
            }

            @Override
            public int priority() {
                return 3;
            }

            @Callback(doc="function():number; Returns the current amount of EXP in the tile")
            public Object[] getExperience(Context c, Arguments a) {
                return new Object[]{((IHaveExperience)this.tile).getContainer().getExperienceTotal()};
            }

            @Callback(doc="function():number; Returns the current amount of experience levels in the tile")
            public Object[] getExperienceLevels(Context c, Arguments a) {
                return new Object[]{((IHaveExperience)this.tile).getContainer().getExperienceLevel()};
            }

            @Callback(doc="function():number; Returns the maximum amount of EXP the tile can store")
            public Object[] getMaxExperience(Context c, Arguments a) {
                return new Object[]{((IHaveExperience)this.tile).getContainer().getMaximumExperiance()};
            }
        }
    }
}

