/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc.driver;

import javax.annotation.Nullable;
import li.cil.oc.api.Network;
import li.cil.oc.api.component.RackMountable;
import li.cil.oc.api.internal.Rack;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Visibility;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.oc.driver.RackMountableWithComponentConnector;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.OCUtils;
import pl.asie.lib.integration.Integration;
import pl.asie.lib.util.WorldUtils;

public class DriverBoardLight
extends RackMountableWithComponentConnector {
    protected final Rack host;
    protected boolean needsUpdate = false;
    public Mode mode;
    public Light[] lights;

    public DriverBoardLight(Rack host) {
        this.host = host;
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent("light_board", Visibility.Network).withConnector().create());
        this.mode = Mode.Default;
        this.lights = this.mode.createLights();
    }

    @Nullable
    public Light getLight(int index) {
        return index >= 0 && index < this.lights.length ? this.lights[index] : null;
    }

    public NBTTagCompound getData() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("m", this.mode.index);
        for (Light light : this.lights) {
            tag.func_74757_a("r_" + light.index, light.isActive);
            if (!light.isActive) continue;
            tag.func_74768_a("c_" + light.index, light.color);
        }
        return tag;
    }

    public void setColor(Light light, int color) {
        if (light.color != color) {
            light.color = color;
            this.needsUpdate = true;
        }
    }

    private void setActive(Light light, boolean active) {
        if (light.isActive != active) {
            light.isActive = active;
            this.needsUpdate = true;
        }
    }

    private void setMode(@Nullable Mode mode) {
        if (mode == null) {
            mode = Mode.Default;
        }
        if (mode != this.mode) {
            this.mode = mode;
            this.lights = mode.createLights();
            this.needsUpdate = true;
        }
    }

    private Light checkLight(int index) {
        Light light = this.getLight(index - 1);
        if (light == null) {
            throw new IllegalArgumentException("index out of range");
        }
        return light;
    }

    @Callback(doc="function(index:number, color:number):boolean; Sets the color of the specified light. Returns true on success, false and an error message otherwise", direct=true)
    public Object[] setColor(Context context, Arguments args) {
        Light light = this.checkLight(args.checkInteger(0));
        int color = args.checkInteger(1);
        if (color >= 0 && color <= 0xFFFFFF) {
            if (this.node.tryChangeBuffer(-Config.LIGHT_BOARD_COLOR_CHANGE_COST)) {
                this.setColor(light, color);
                return new Object[]{true};
            }
            return new Object[]{false, "not enough energy"};
        }
        return new Object[]{false, "number must be between 0 and 16777215"};
    }

    @Callback(doc="function(index:number):number; Returns the color of the specified light on success, false and an error message otherwise", direct=true)
    public Object[] getColor(Context context, Arguments args) {
        return new Object[]{this.checkLight((int)args.checkInteger((int)0)).color};
    }

    @Callback(doc="function(index:number, active:boolean):boolean; Turns the specified light on or off. Returns true on success, false and an error message otherwise", direct=true)
    public Object[] setActive(Context context, Arguments args) {
        Light light = this.checkLight(args.checkInteger(0));
        boolean active = args.checkBoolean(1);
        if (this.node.tryChangeBuffer(-Config.LIGHT_BOARD_COLOR_CHANGE_COST)) {
            this.setActive(light, active);
            return new Object[]{true};
        }
        return new Object[]{false, "not enough energy"};
    }

    @Callback(doc="function(index:number):boolean; Returns true if the light at the specified position is currently active", direct=true)
    public Object[] isActive(Context context, Arguments args) {
        return new Object[]{this.checkLight((int)args.checkInteger((int)0)).isActive};
    }

    @Callback(value="light_count", doc="This represents the number of lights on the board.", direct=true, getter=true)
    public Object[] getLightCount(Context context, Arguments args) {
        return new Object[]{this.lights.length};
    }

    public boolean canUpdate() {
        return true;
    }

    public void update() {
        for (Light light : this.lights) {
            if (!light.isActive || this.node.tryChangeBuffer(-Config.LIGHT_BOARD_COLOR_MAINTENANCE_COST)) continue;
            this.setActive(light, false);
            break;
        }
        if (this.needsUpdate) {
            this.host.markChanged(this.host.indexOfMountable((RackMountable)this));
            this.needsUpdate = false;
        }
    }

    public void load(NBTTagCompound tag) {
        super.load(tag);
        if (tag.func_74764_b("m")) {
            this.setMode(Mode.fromIndex(tag.func_74762_e("m")));
            for (Light light : this.lights) {
                if (tag.func_74764_b("r_" + light.index)) {
                    this.setActive(light, tag.func_74767_n("r_" + light.index));
                }
                if (!tag.func_74764_b("c_" + light.index)) continue;
                this.setColor(light, tag.func_74762_e("c_" + light.index));
            }
        }
    }

    public void save(NBTTagCompound tag) {
        super.save(tag);
        tag.func_74768_a("m", this.mode.index);
        for (Light light : this.lights) {
            tag.func_74757_a("r_" + light.index, light.isActive);
            if (!light.isActive) continue;
            tag.func_74768_a("c_" + light.index, light.color);
        }
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        BlockPos pos = new BlockPos(this.host.xPosition(), this.host.yPosition(), this.host.zPosition());
        if (!heldItem.func_190926_b() && Integration.isTool(heldItem, player, hand, pos) && Integration.useTool(heldItem, player, hand, pos)) {
            int index = this.mode.index;
            if (index >= Mode.VALUES.length) {
                index = 0;
            }
            this.setMode(Mode.fromIndex(index + 1));
            this.host.markChanged(this.host.indexOfMountable((RackMountable)this));
            this.needsUpdate = false;
            WorldUtils.notifyBlockUpdate(this.host.world(), pos);
            return true;
        }
        return false;
    }

    @Override
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("display", "Light board", "Lumiose Lighting", "LED-15 X", new String[0]);
    }

    public static enum Mode {
        Default(4){

            @Override
            public float getU0(int index) {
                return (float)((index - 1) * 4) / 16.0f;
            }

            @Override
            public float getU1(int index, float u0) {
                return u0 + 0.25f;
            }
        }
        ,
        Regular(5){

            @Override
            public float getU0(int index) {
                return (float)((index - 1) * 3) / 16.0f;
            }

            @Override
            public float getU1(int index, float u0) {
                return u0 + 0.1875f;
            }
        }
        ,
        Five(10){

            @Override
            public float getU0(int index) {
                return (float)(index <= 5 ? 1 + index : 3 + index) / 16.0f;
            }

            @Override
            public float getU1(int index, float u0) {
                return u0 + 0.0625f;
            }
        }
        ,
        Twelve(12){

            @Override
            public float getU0(int index) {
                return (float)(index + 1) / 16.0f;
            }

            @Override
            public float getU1(int index, float u0) {
                return u0 + 0.0625f;
            }
        }
        ,
        Total(42){

            @Override
            public float getU0(int index) {
                return (float)((index - 1) % 14 + 1) / 16.0f;
            }

            @Override
            public float getU1(int index, float u0) {
                return u0 + 0.0625f;
            }

            @Override
            public float getV0(int index, float v0, float v1) {
                if (--index >= 14) {
                    int diff = index / 14;
                    v0 += (float)diff / 16.0f;
                }
                return v0;
            }

            @Override
            public float getV1(int index, float v0, float v1) {
                return v0 + 0.0625f;
            }

            @Override
            public Light[] createLights() {
                Light[] lights;
                for (Light light : lights = super.createLights()) {
                    light.color = 0x111111;
                }
                return lights;
            }
        };

        public final int index = this.ordinal() + 1;
        public final int lightcount;
        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite background;
        public final ResourceLocation foreground;
        public final String backgroundPath;
        public static final Mode[] VALUES;

        private Mode(int lightcount) {
            this.lightcount = lightcount;
            this.foreground = new ResourceLocation("computronics", "textures/blocks/light_board/mode_" + this.index + "_lights.png");
            this.backgroundPath = "computronics:blocks/light_board/mode_" + this.index;
        }

        public abstract float getU0(int var1);

        public abstract float getU1(int var1, float var2);

        public float getV0(int index, float v0, float v1) {
            return v0;
        }

        public float getV1(int index, float v0, float v1) {
            return v1;
        }

        public Light[] createLights() {
            Light[] lights = new Light[this.lightcount];
            for (int i = 0; i < this.lightcount; ++i) {
                lights[i] = new Light(i + 1);
            }
            return lights;
        }

        @SideOnly(value=Side.CLIENT)
        public void registerIcons(TextureMap map) {
            this.background = map.func_174942_a(new ResourceLocation(this.backgroundPath));
        }

        @Nullable
        public static Mode fromIndex(int index) {
            return index > 0 && index <= VALUES.length ? VALUES[index - 1] : null;
        }

        static {
            VALUES = Mode.values();
        }
    }

    public static class Light {
        protected int color = 0xC0C0C0;
        protected boolean isActive = false;
        public final int index;

        Light(int index) {
            this.index = index;
        }
    }
}

