/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.forestry;

import forestry.core.items.ItemWrench;
import forestry.core.tiles.TileAnalyzer;
import forestry.core.tiles.TileEngine;
import forestry.core.tiles.TilePowered;
import forestry.energy.tiles.TileEngineBiogas;
import forestry.energy.tiles.TileEngineClockwork;
import forestry.energy.tiles.TileEnginePeat;
import forestry.factory.tiles.TileBottler;
import forestry.factory.tiles.TileCarpenter;
import forestry.factory.tiles.TileCentrifuge;
import forestry.factory.tiles.TileFabricator;
import forestry.factory.tiles.TileFermenter;
import forestry.factory.tiles.TileMillRainmaker;
import forestry.factory.tiles.TileMoistener;
import forestry.factory.tiles.TileRaintank;
import forestry.factory.tiles.TileSqueezer;
import forestry.factory.tiles.TileStill;
import forestry.farming.tiles.TileFarmGearbox;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.cyclops.commoncapabilities.CommonCapabilities;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.temperature.ITemperature;
import org.cyclops.commoncapabilities.api.capability.work.IWorker;
import org.cyclops.commoncapabilities.api.capability.wrench.DefaultWrench;
import org.cyclops.commoncapabilities.api.capability.wrench.IWrench;
import org.cyclops.commoncapabilities.capability.recipehandler.RecipeHandlerConfig;
import org.cyclops.commoncapabilities.capability.temperature.TemperatureConfig;
import org.cyclops.commoncapabilities.capability.worker.WorkerConfig;
import org.cyclops.commoncapabilities.capability.wrench.WrenchConfig;
import org.cyclops.commoncapabilities.modcompat.forestry.capability.recipehandler.TileCarpenterRecipeHandler;
import org.cyclops.commoncapabilities.modcompat.forestry.capability.recipehandler.TileCentrifugeRecipeHandler;
import org.cyclops.commoncapabilities.modcompat.forestry.capability.recipehandler.TileFabricatorRecipeHandler;
import org.cyclops.commoncapabilities.modcompat.forestry.capability.recipehandler.TileFermenterRecipeHandler;
import org.cyclops.commoncapabilities.modcompat.forestry.capability.recipehandler.TileSqueezerRecipeHandler;
import org.cyclops.commoncapabilities.modcompat.forestry.capability.recipehandler.TileStillRecipeHandler;
import org.cyclops.commoncapabilities.modcompat.forestry.capability.temperature.TileEngineTemperature;
import org.cyclops.commoncapabilities.modcompat.forestry.capability.work.TileEngineWorker;
import org.cyclops.commoncapabilities.modcompat.forestry.capability.work.TileFarmGearboxWorker;
import org.cyclops.commoncapabilities.modcompat.forestry.capability.work.TileMoistenerWorker;
import org.cyclops.commoncapabilities.modcompat.forestry.capability.work.TilePoweredWorker;
import org.cyclops.commoncapabilities.modcompat.forestry.capability.work.TileRainmakerWorker;
import org.cyclops.commoncapabilities.modcompat.forestry.capability.work.TileRaintankWorker;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.cyclopscore.modcompat.IModCompat;
import org.cyclops.cyclopscore.modcompat.capabilities.CapabilityConstructorRegistry;
import org.cyclops.cyclopscore.modcompat.capabilities.DefaultCapabilityProvider;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityConstructor;
import org.cyclops.cyclopscore.modcompat.capabilities.SimpleCapabilityConstructor;

public class ForestryModCompat
implements IModCompat {
    public String getModID() {
        return "forestry";
    }

    public boolean isEnabled() {
        return true;
    }

    public String getComment() {
        return "Worker, Wrench and Temperature capabilities for Forestry machines.";
    }

    public void onInit(IInitListener.Step initStep) {
        if (initStep == IInitListener.Step.INIT) {
            CapabilityConstructorRegistry registry = CommonCapabilities._instance.getCapabilityConstructorRegistry();
            ForestryModCompat.registerEngineTemperature(registry, TileEngineBiogas.class, 10273.15);
            ForestryModCompat.registerEngineTemperature(registry, TileEngineClockwork.class, 300273.15);
            ForestryModCompat.registerEngineTemperature(registry, TileEnginePeat.class, 10273.15);
            registry.registerItem(ItemWrench.class, (ICapabilityConstructor)new ICapabilityConstructor<IWrench, ItemWrench, ItemStack>(){

                public Capability<IWrench> getCapability() {
                    return WrenchConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(ItemWrench hostType, ItemStack host) {
                    return new DefaultCapabilityProvider(WrenchConfig.CAPABILITY, (Object)new DefaultWrench());
                }
            });
            ForestryModCompat.registerTilePoweredWorker(registry, TileStill.class);
            ForestryModCompat.registerTilePoweredWorker(registry, TileCarpenter.class);
            ForestryModCompat.registerTilePoweredWorker(registry, TileFermenter.class);
            ForestryModCompat.registerTilePoweredWorker(registry, TileSqueezer.class);
            ForestryModCompat.registerTilePoweredWorker(registry, TileBottler.class);
            ForestryModCompat.registerTilePoweredWorker(registry, TileCentrifuge.class);
            ForestryModCompat.registerTilePoweredWorker(registry, TileAnalyzer.class);
            ForestryModCompat.registerTilePoweredWorker(registry, TileFabricator.class);
            ForestryModCompat.registerTileEngineWorker(registry, TileEngineBiogas.class);
            ForestryModCompat.registerTileEngineWorker(registry, TileEngineClockwork.class);
            ForestryModCompat.registerTileEngineWorker(registry, TileEnginePeat.class);
            registry.registerTile(TileMoistener.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, TileMoistener>(){

                public Capability<IWorker> getCapability() {
                    return WorkerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(TileMoistener host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new TileMoistenerWorker(host));
                }
            });
            registry.registerTile(TileMillRainmaker.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, TileMillRainmaker>(){

                public Capability<IWorker> getCapability() {
                    return WorkerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(TileMillRainmaker host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new TileRainmakerWorker(host));
                }
            });
            registry.registerTile(TileRaintank.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, TileRaintank>(){

                public Capability<IWorker> getCapability() {
                    return WorkerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(TileRaintank host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new TileRaintankWorker(host));
                }
            });
            registry.registerTile(TileFarmGearbox.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, TileFarmGearbox>(){

                public Capability<IWorker> getCapability() {
                    return WorkerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(TileFarmGearbox host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new TileFarmGearboxWorker(host));
                }
            });
            ForestryModCompat.registerTileRecipeHandler(registry, TileStill.class, TileStillRecipeHandler::new);
            ForestryModCompat.registerTileRecipeHandler(registry, TileCarpenter.class, TileCarpenterRecipeHandler::new);
            ForestryModCompat.registerTileRecipeHandler(registry, TileFermenter.class, TileFermenterRecipeHandler::new);
            ForestryModCompat.registerTileRecipeHandler(registry, TileSqueezer.class, TileSqueezerRecipeHandler::new);
            ForestryModCompat.registerTileRecipeHandler(registry, TileCentrifuge.class, TileCentrifugeRecipeHandler::new);
            ForestryModCompat.registerTileRecipeHandler(registry, TileFabricator.class, TileFabricatorRecipeHandler::new);
        }
    }

    protected static <T extends TileEngine> void registerEngineTemperature(CapabilityConstructorRegistry registry, Class<T> clazz, final double maximumTemperature) {
        registry.registerTile(clazz, (ICapabilityConstructor)new SimpleCapabilityConstructor<ITemperature, T>(){

            public Capability<ITemperature> getCapability() {
                return TemperatureConfig.CAPABILITY;
            }

            @Nullable
            public ICapabilityProvider createProvider(T host) {
                return new DefaultCapabilityProvider(this::getCapability, (Object)new TileEngineTemperature((TileEngine)host, maximumTemperature, 273.15, 273.15));
            }
        });
    }

    protected static <T extends TilePowered> void registerTilePoweredWorker(CapabilityConstructorRegistry registry, Class<T> clazz) {
        registry.registerTile(clazz, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, T>(){

            public Capability<IWorker> getCapability() {
                return WorkerConfig.CAPABILITY;
            }

            @Nullable
            public ICapabilityProvider createProvider(T host) {
                return new DefaultCapabilityProvider(this::getCapability, (Object)new TilePoweredWorker((TilePowered)host));
            }
        });
    }

    protected static <T extends TileEngine> void registerTileEngineWorker(CapabilityConstructorRegistry registry, Class<T> clazz) {
        registry.registerTile(clazz, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, T>(){

            public Capability<IWorker> getCapability() {
                return WorkerConfig.CAPABILITY;
            }

            @Nullable
            public ICapabilityProvider createProvider(T host) {
                return new DefaultCapabilityProvider(this::getCapability, (Object)new TileEngineWorker((TileEngine)host));
            }
        });
    }

    protected static <T extends TilePowered> void registerTileRecipeHandler(CapabilityConstructorRegistry registry, Class<T> clazz, final Supplier<IRecipeHandler> recipeHandlerSupplier) {
        final Wrapper recipeHandler = new Wrapper();
        registry.registerTile(clazz, (ICapabilityConstructor)new SimpleCapabilityConstructor<IRecipeHandler, T>(){

            public Capability<IRecipeHandler> getCapability() {
                return RecipeHandlerConfig.CAPABILITY;
            }

            @Nullable
            public ICapabilityProvider createProvider(T host) {
                if (recipeHandler.get() == null) {
                    recipeHandler.set(recipeHandlerSupplier.get());
                }
                return new DefaultCapabilityProvider(this::getCapability, recipeHandler.get());
            }
        });
    }
}

